/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PatentNumber;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class PatentHandler
implements GenericHandler<Patent, ReferenceType> {
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final GenericHandler<PatentNumber, String> patentNumberHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public PatentHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.citationFactory = citationFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.patentNumberHandler = new PatentNumberHandler(citationFactory);
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
    }

    @Override
    public Patent fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            Patent citation = this.citationFactory.buildPatent();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            PatentNumber patentNumber = this.patentNumberHandler.fromXmlBinding(citationXML.getNumber());
            if (patentNumber != null) {
                citation.setPatentNumber(patentNumber);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(Patent citation) {
        if (citation != null) {
            ReferenceType referenceXML = this.objectFactory.createReferenceType();
            CitationType citationXML = this.objectFactory.createCitationType();
            referenceXML.setCitation(citationXML);
            citationXML.setType("patent");
            citationXML.setNumber(this.patentNumberHandler.toXmlBinding(citation.getPatentNumber()));
            this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
            return referenceXML;
        }
        return null;
    }

    private class PatentNumberHandler
    implements GenericHandler<PatentNumber, String> {
        private final CitationNewFactory citationFactory;

        PatentNumberHandler(CitationNewFactory citationFactory) {
            this.citationFactory = citationFactory;
        }

        @Override
        public PatentNumber fromXmlBinding(String XML) {
            if (XML != null && XML.length() > 0) {
                return this.citationFactory.buildPatentNumber(XML);
            }
            return null;
        }

        @Override
        public String toXmlBinding(PatentNumber citation) {
            if (citation.getValue() != null && citation.getValue().trim().length() > 0) {
                return citation.getValue();
            }
            return null;
        }
    }
}

