/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.InternalReferenceHandler;

public abstract class XMLKrakenConverter<MODEL_TYPE, XML_MODEL_TYPE> {
    protected UniProtFactory factory;
    protected ObjectFactory objectFactory = new ObjectFactory();
    protected InternalReferenceHandler referenceHandler;
    private final Pattern keyPattern = Pattern.compile("(EC|EP|EA|EI)(\\d+)");

    public XMLKrakenConverter() {
        this.factory = DefaultUniProtFactory.getInstance();
    }

    public XMLKrakenConverter(UniProtFactory factory) {
        this.factory = factory;
    }

    public abstract void fromJAXB(XML_MODEL_TYPE var1, MODEL_TYPE var2) throws JAXBException;

    public abstract void toJAXB(MODEL_TYPE var1, XML_MODEL_TYPE var2) throws JAXBException;

    public void setInternalReferenceHandler(InternalReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    protected List<Integer> writeEvidenceIDs(List<EvidenceId> evidenceIds) {
        ArrayList<Integer> evidences = new ArrayList<Integer>();
        for (EvidenceId evidenceId : evidenceIds) {
            String evidenceIdValue = evidenceId.getValue().trim();
            Matcher matcher = this.keyPattern.matcher(evidenceIdValue);
            if (matcher.matches()) {
                evidences.add(this.referenceHandler.getIndexForEvidenceId(evidenceIdValue));
                continue;
            }
            throw new IllegalArgumentException("The evidence reference does not contain an old reference format: " + evidenceId.toString());
        }
        return evidences;
    }

    protected List<EvidenceId> parseEvidenceIDs(List<Integer> evidences) {
        ArrayList<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();
        if (evidences != null && !evidences.isEmpty()) {
            EvidenceFactory evidenceFactory = this.factory.buildEvidenceFactory();
            for (Integer evidence : evidences) {
                evidenceIds.add(evidenceFactory.buildEvidenceId(this.referenceHandler.getEvidenceIdForIndex(evidence)));
            }
        }
        return evidenceIds;
    }
}

