/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.Entry;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinExistenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.util.XMLDateHelper;

public class MetaUpdater
implements GenericUpdater<UniProtEntry, Entry> {
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;
    private final XMLDateHelper dateHelper;

    public MetaUpdater(UniProtFactory uniProtFactory, ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.uniProtFactory = uniProtFactory;
        this.dateHelper = new XMLDateHelper();
    }

    @Override
    public void fromXmlBinding(UniProtEntry entry, Entry xmlEntry) {
        entry.setType(UniProtEntryType.typeOf(xmlEntry.getDataset()));
        entry.setProteinExistence(ProteinExistence.typeOf(xmlEntry.getProteinExistence().getType()));
        UniProtId id = this.uniProtFactory.buildUniProtId(xmlEntry.getName().get(0));
        entry.setUniProtId(id);
        List<String> accessions = xmlEntry.getAccession();
        entry.setPrimaryUniProtAccession(this.uniProtFactory.buildPrimaryUniProtAccession(accessions.remove(0)));
        for (String acc : accessions) {
            entry.getSecondaryUniProtAccessions().add(this.uniProtFactory.buildSecondaryUniProtAccession(acc));
        }
        GregorianCalendar creation = xmlEntry.getCreated().toGregorianCalendar();
        creation.set(11, 1);
        entry.getEntryAudit().setFirstPublicDate(creation.getTime());
        GregorianCalendar lastAnnotation = xmlEntry.getModified().toGregorianCalendar();
        lastAnnotation.set(11, 1);
        entry.getEntryAudit().setLastAnnotationUpdateDate(lastAnnotation.getTime());
        entry.getEntryAudit().setEntryVersion(xmlEntry.getVersion());
    }

    @Override
    public void toXmlBinding(Entry xmlEntry, UniProtEntry entry) {
        xmlEntry.setDataset(entry.getType().getValue());
        this.setPersistenceOnXml(xmlEntry, entry);
        this.setNameOnXml(xmlEntry, entry);
        this.setAccessionsOnXml(xmlEntry, entry);
        this.setDatesOnXml(xmlEntry, entry);
        this.setVersionNumberOnXml(xmlEntry, entry);
    }

    private void setVersionNumberOnXml(Entry xmlEntry, UniProtEntry entry) {
        int entryVersion = entry.getEntryAudit().getEntryVersion();
        xmlEntry.setVersion(entryVersion);
    }

    private void setDatesOnXml(Entry xmlEntry, UniProtEntry entry) {
        boolean includeTimezone = false;
        xmlEntry.setCreated(this.dateHelper.convertDate(entry.getEntryAudit().getFirstPublicDate(), includeTimezone));
        xmlEntry.setModified(this.dateHelper.convertDate(entry.getEntryAudit().getLastAnnotationUpdateDate(), includeTimezone));
    }

    private void setAccessionsOnXml(Entry xmlEntry, UniProtEntry entry) {
        ArrayList<UniProtAccession> accessions = new ArrayList<UniProtAccession>();
        accessions.add(entry.getPrimaryUniProtAccession());
        accessions.addAll(entry.getSecondaryUniProtAccessions());
        for (UniProtAccession uniProtAccession : accessions) {
            xmlEntry.getAccession().add(uniProtAccession.getValue());
        }
    }

    private void setNameOnXml(Entry xmlEntry, UniProtEntry entry) {
        xmlEntry.getName().add(entry.getUniProtId().getValue());
    }

    private void setPersistenceOnXml(Entry xmlEntry, UniProtEntry entry) {
        ProteinExistenceType pet = this.objectFactory.createProteinExistenceType();
        pet.setType(entry.getProteinExistence().getValue().toLowerCase());
        xmlEntry.setProteinExistence(pet);
    }
}

