/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeyListProxy;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordNotRecognizedException;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.xml.uniprot.KeywordListConverter;
import uk.ac.ebi.kraken.xml.uniprot.KeywordListHandler;

public class KeyListProxyFromXml
implements KeyListProxy {
    private KeywordListHandler handler;
    private File keyFile;

    public void setFileName(String fn) {
        try {
            this.keyFile = new File(fn);
            this.handler = new KeywordListHandler(this.keyFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot access keyword list file @" + fn);
        }
    }

    @Override
    public String getIdForName(String name) {
        try {
            return this.handler.getIdForName(name);
        }
        catch (Exception e) {
            throw new KeywordNotRecognizedException(e.getMessage());
        }
    }

    @Override
    public String getNameForId(String id) {
        return this.handler.getNameForId(id);
    }

    @Override
    public List<KeywordEntry> getKeywordList() {
        try {
            KeywordListConverter converter = new KeywordListConverter(DefaultKeywordListFactory.getInstance());
            return converter.readKeywordList(this.keyFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot access keyword list file @" + this.keyFile.toString());
        }
    }

    @Override
    public boolean keywordExists(String name) {
        try {
            if (this.handler.getIdForName(name) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }
}

