/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.merge;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.CommaParameterSplitter;
import com.google.common.base.Strings;
import java.util.List;
import uk.ac.ebi.kraken.xml.merge.XmlFileMergeConfigure;

public class XmlFileMergeConfigureImpl
implements XmlFileMergeConfigure {
    @Parameter(names={"-if"}, splitter=CommaParameterSplitter.class, description="input xml files, comma separated for merge")
    private List<String> inputFiles;
    @Parameter(names={"-of"}, description="output merged xml file")
    private String outputFile;
    @Parameter(names={"-nohf"}, description="not include Xml header and footer")
    private boolean noIncludeHeaderFooter;
    private JCommander jCommander;

    private XmlFileMergeConfigureImpl() {
    }

    public static final XmlFileMergeConfigure fromCommandLine(String[] args) {
        XmlFileMergeConfigureImpl configurator = new XmlFileMergeConfigureImpl();
        configurator.jCommander = new JCommander((Object)configurator, args);
        return configurator;
    }

    @Override
    public boolean isValid() {
        return this.inputFiles != null && !this.inputFiles.isEmpty() && !Strings.isNullOrEmpty((String)this.outputFile);
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public List<String> getInputFiles() {
        return this.inputFiles;
    }

    @Override
    public String getUsage() {
        StringBuilder out = new StringBuilder();
        this.jCommander.usage(out);
        return out.toString();
    }

    @Override
    public boolean includeHeaderFooder() {
        return !this.noIncludeHeaderFooter;
    }
}

