/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.stringrange;

import java.util.Objects;
import uk.ac.ebi.kraken.util.stringrange.StringRange;

public class SingleString
implements StringRange {
    private final String value;

    public SingleString(String value) {
        this.value = Objects.requireNonNull(value, "string must not be null");
    }

    @Override
    public boolean isInRange(String target, boolean ignoreCase) {
        String temp;
        if (ignoreCase) {
            target = target.toLowerCase();
            temp = this.value.toLowerCase();
        } else {
            temp = this.value;
        }
        return temp.equals(target);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleString)) {
            return false;
        }
        SingleString singleString = (SingleString)o;
        return this.value.equals(singleString.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "SingleString{value='" + this.value + "'}";
    }
}

