/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.sequence;

public enum AminoAcid {
    ALANINE("ALA", "A", true, "Ala"),
    ASPARTIC_ACID("ASX", "B", true, "Asx"),
    CYSTEINE("CYS", "C", true, "Cys"),
    ASPARTATE("ASP", "D", true, "Asp"),
    GLUTAMATE("GLU", "E", true, "Glu"),
    PHENYLALANINE("PHE", "F", true, "Phe"),
    GLYCINE("GLY", "G", true, "Gly"),
    HISTIDINE("HIS", "H", true, "His"),
    ISOLEUCINE("ILE", "I", true, "Ile"),
    LYSINE("LYS", "K", true, "Lys"),
    LEUCINE("LEU", "L", true, "Leu"),
    METHIONINE("MET", "M", true, "Met"),
    ASPARAGINE("ASN", "N", true, "Asn"),
    PROLINE("PRO", "P", true, "Pro"),
    GLUTAMINE("GLN", "Q", true, "Gln"),
    ARGININE("ARG", "R", true, "Arg"),
    SERINE("SER", "S", true, "Ser"),
    THREONINE("THR", "T", true, "Thr"),
    VALINE("VAL", "V", true, "Val"),
    TRYPTOPHAN("TRP", "W", true, "Trp"),
    TYROSINE("TYR", "Y", true, "Tyr"),
    GLUTAMIC_ACID("GLX", "Z", true, "Glx"),
    SELENOMETHIONINE("MSE", "M", true, "Mse"),
    SELENOCYSTEINE("CSE", "U", false, "Cse"),
    PYRROLYSINE("PYR", "O", false, "Pyr"),
    TER("TER", "*", false, "Ter"),
    UNKNOWN("UNK", "X", false, "Unk");

    private final String threeLetterCode;
    private final String oneLetterCode;
    private final boolean standard;
    private final String humanReadable3LetterCode;

    private AminoAcid(String threeLetter, String oneLetter, boolean standard, String hr3LetterCode) {
        this.threeLetterCode = threeLetter;
        this.oneLetterCode = oneLetter;
        this.standard = standard;
        this.humanReadable3LetterCode = hr3LetterCode;
    }

    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    public boolean isStandardAminoAcid() {
        return this.standard;
    }

    public String getHumanReadable_Three_LetterCode() {
        return this.humanReadable3LetterCode;
    }

    public static AminoAcid valueOfIgnoreCase(String aminoAcidSymbol) {
        if (aminoAcidSymbol.length() == 3) {
            return AminoAcid.valueOfThreeLetterCode(aminoAcidSymbol);
        }
        if (aminoAcidSymbol.length() == 1) {
            return AminoAcid.valueOfOneLetterCode(aminoAcidSymbol);
        }
        return AminoAcid.valueOfName(aminoAcidSymbol);
    }

    public static AminoAcid valueOfName(String name) {
        for (AminoAcid aminoAcid : AminoAcid.values()) {
            if (!aminoAcid.toString().equalsIgnoreCase(name)) continue;
            return aminoAcid;
        }
        return UNKNOWN;
    }

    public static AminoAcid valueOfThreeLetterCode(String threeLetterCode) {
        for (AminoAcid aminoAcid : AminoAcid.values()) {
            if (!aminoAcid.getThreeLetterCode().equalsIgnoreCase(threeLetterCode)) continue;
            return aminoAcid;
        }
        return UNKNOWN;
    }

    public static AminoAcid valueOfOneLetterCode(String oneLetterCode) {
        for (AminoAcid aminoAcid : AminoAcid.values()) {
            if (!aminoAcid.getOneLetterCode().equalsIgnoreCase(oneLetterCode)) continue;
            return aminoAcid;
        }
        return UNKNOWN;
    }
}

