/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.metric;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import uk.ac.ebi.kraken.util.metric.PushGatwayMetric;

public class PrometheusPushGatwayMetric
extends PushGatwayMetric {
    public PrometheusPushGatwayMetric(String name, String help, double value) {
        super(name, help, value);
    }

    public PrometheusPushGatwayMetric(String name, String help, double value, Map<String, String> labelsKeyValue) {
        super(name, help, value, labelsKeyValue);
    }

    @Override
    public String getFormattedMetric() {
        StringBuilder response = new StringBuilder();
        response.append(this.name);
        if (this.labelsKeyValue != null && !this.labelsKeyValue.isEmpty()) {
            response.append("{");
            for (Map.Entry label : this.labelsKeyValue.entrySet()) {
                response.append(String.format("%s=\"%s\",", label.getKey(), this.escapeLabelValue(String.valueOf(label.getValue()))));
            }
            response.setLength(response.length() - 1);
            response.append("}");
        }
        response.append(" ");
        DecimalFormat df = new DecimalFormat("#.####");
        df.setRoundingMode(RoundingMode.DOWN);
        response.append(df.format(this.value));
        return response.toString();
    }

    @Override
    public String getFormattedMetricHelp() {
        if (this.help != null) {
            StringBuilder response = new StringBuilder();
            response.append("# HELP ").append(this.name).append(" ").append(this.escapeHelp(this.help));
            return response.toString();
        }
        return null;
    }

    private String escapeHelp(String s) {
        return s.replace("\\", "\\\\").replace("\n", "\\n");
    }

    private String escapeLabelValue(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }
}

