/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.StreamGobbler;

public class ExternalProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcess.class);

    private ExternalProcess() {
    }

    public static int run(String arg, int mode) {
        return ExternalProcess.run(arg, mode, null);
    }

    public static int run(String arg, int mode, String workingFolder) {
        try {
            String[] args = null;
            if (mode == 0) {
                args = arg.split(" ");
            } else if (mode == 1) {
                args = arg.split("###");
            }
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if (workingFolder != null) {
                processBuilder.directory(new File(workingFolder));
            }
            Process process = processBuilder.start();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = process.waitFor();
            LOG.info("ExitValue   : {}", (Object)exitVal);
            return exitVal;
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted run", (Throwable)ie);
            return -1;
        }
        catch (IOException e) {
            LOG.error("IO issues", (Throwable)e);
            return -1;
        }
    }

    public static int run(String[] args, int mode, String workingFolder) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if (workingFolder != null) {
                processBuilder.directory(new File(workingFolder));
            }
            Process process = processBuilder.start();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = process.waitFor();
            LOG.info("ExitValue   : {}", (Object)exitVal);
            return exitVal;
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted run", (Throwable)ie);
            return -1;
        }
        catch (IOException e) {
            LOG.error("IO issues", (Throwable)e);
            return -1;
        }
    }

    public static String runNoWait(String arg) {
        try {
            String line;
            Runtime rt = Runtime.getRuntime();
            Process process = rt.exec(arg);
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            BufferedReader bufReader = new BufferedReader(reader);
            String finaloutput = "";
            while ((line = bufReader.readLine()) != null) {
                LOG.info(line);
                finaloutput = finaloutput + line;
            }
            return finaloutput;
        }
        catch (IOException e) {
            LOG.error("IO issues", (Throwable)e);
            return "";
        }
    }
}

