/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DatabaseDefContext;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.DbDisplayOrder;
import uk.ac.ebi.kraken.model.uniprot.dbx.UniProtXDbDisplayOrder;

public class UniProtXRefDBDefCache
implements DatabaseDefContext {
    private static List<DbDisplayOrder> databaseDefs;
    private static List<String> databases;
    private static Map<String, DbDisplayOrder> databaseType2DefsNoCase;
    private static String DR_ORD_FILE;
    private static String dr_ord_location;
    private static String dr_ord_location_new;
    private static boolean init;

    public UniProtXRefDBDefCache() {
        this.initCache();
    }

    private synchronized void initCache() {
        if (init) {
            return;
        }
        databaseDefs = new CopyOnWriteArrayList<DbDisplayOrder>();
        databases = new CopyOnWriteArrayList<String>();
        databaseType2DefsNoCase = new ConcurrentHashMap<String, DbDisplayOrder>();
        try {
            BufferedReader orderFileReader = UniProtXRefDBDefCache.getReader(dr_ord_location_new, dr_ord_location);
            if (orderFileReader == null) {
                InputStream in = this.getFileAsStream(DR_ORD_FILE);
                if (in == null) {
                    System.err.println("could not open dr order file: " + DR_ORD_FILE);
                }
                orderFileReader = new BufferedReader(new InputStreamReader(in));
            }
            String readLine = orderFileReader.readLine();
            Integer pos = 1;
            while (readLine != null) {
                if (!(readLine = readLine.trim()).startsWith("#")) {
                    DbDisplayOrder def = this.createDatabaseDef(readLine, pos);
                    databaseDefs.add(def);
                    databases.add(def.getDbName());
                    databaseType2DefsNoCase.put(def.getDbName().toUpperCase(), def);
                    Integer n = pos;
                    Integer n2 = pos = Integer.valueOf(pos + 1);
                }
                readLine = orderFileReader.readLine();
            }
            orderFileReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        init = true;
    }

    DbDisplayOrder createDatabaseDef(String line, int pos) {
        String[] data = line.split(" ");
        String db = data[0].trim();
        int secondOrder = 1;
        if (data.length > 1) {
            secondOrder = this.getSecondOrder(data[1]);
        }
        return new UniProtXDbDisplayOrder(db, pos, secondOrder);
    }

    private int getSecondOrder(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private static BufferedReader getReader(String filename, String queryUrl) {
        if (Files.isReadable(Paths.get(filename, new String[0]))) {
            try {
                return new BufferedReader(new FileReader(new File(filename)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        URLConnection urlConnection = null;
        URL url = null;
        BufferedReader reader = null;
        try {
            url = new URL(queryUrl);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.setUseCaches(true);
            urlConnection.connect();
            reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reader;
    }

    private InputStream getFileAsStream(String filename) {
        try {
            InputStream in = UniProtXRefDBDefCache.class.getClassLoader().getResourceAsStream(filename);
            if (in != null) {
                return in;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = new File(filename);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<DbDisplayOrder> getAllXRefDBDefs() {
        return databaseDefs;
    }

    @Override
    public List<String> getAllXrefDBName() {
        return databases;
    }

    @Override
    public DbDisplayOrder getXRefDBDef(DatabaseType type) {
        return databaseType2DefsNoCase.get(type.getName().toUpperCase());
    }

    static {
        DR_ORD_FILE = "META-INF/conf/dr_ord";
        dr_ord_location = "https://www.ebi.ac.uk/~trembl/generator/dr_ord";
        dr_ord_location_new = "/ebi/sp/misc1/pc/sprot/cv/dr_ord";
        init = false;
    }
}

