/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;

public class PhysiologicalDirectionImpl
implements PhysiologicalReaction {
    private static final long serialVersionUID = 1L;
    private List<EvidenceId> evidences = new ArrayList<EvidenceId>();
    private PhysiologicalDirectionType directionType;
    private ReactionReference reference;

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidences.clear();
        this.evidences.addAll(evidences);
    }

    @Override
    public PhysiologicalDirectionType getDirectionType() {
        return this.directionType;
    }

    @Override
    public ReactionReference getReactionReference() {
        return this.reference;
    }

    @Override
    public void setDirectionType(PhysiologicalDirectionType type) {
        this.directionType = type;
    }

    @Override
    public void setReactionReference(ReactionReference reference) {
        this.reference = reference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PhysiologicalDirection=").append(this.directionType.toDisplayName()).append(";");
        sb.append(" Xref=").append(this.reference.toString()).append(";");
        if (!this.evidences.isEmpty()) {
            sb.append(" Evidence={").append(this.evidences.stream().map(val -> val.toString()).collect(Collectors.joining(", "))).append("};");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directionType == null ? 0 : this.directionType.hashCode());
        result = 31 * result + (this.evidences == null ? 0 : this.evidences.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhysiologicalDirectionImpl other = (PhysiologicalDirectionImpl)obj;
        if (this.directionType != other.directionType) {
            return false;
        }
        if (this.evidences == null ? other.evidences != null : !this.evidences.equals(other.evidences)) {
            return false;
        }
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }
}

