/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class MassSpectrometryCommentImpl
extends CommentImpl
implements MassSpectrometryComment {
    private MassSpectrometryCommentNote note;
    private float molWeight;
    private float molWeightError;
    private MassSpectrometryMethod method;
    private List<MassSpectrometryCommentSource> massSpectrometryCommentSources;

    public MassSpectrometryCommentImpl() {
        this.setCommentType(CommentType.MASS_SPECTROMETRY);
        this.massSpectrometryCommentSources = new ArrayList<MassSpectrometryCommentSource>();
        this.note = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryCommentNote("");
        this.molWeight = 0.0f;
        this.molWeightError = 0.0f;
        this.method = MassSpectrometryMethod.UNKNOWN;
    }

    public MassSpectrometryCommentImpl(MassSpectrometryComment copy) {
        this();
        this.setCommentType(CommentType.MASS_SPECTROMETRY);
        this.note = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryCommentNote("");
        this.molWeight = 0.0f;
        this.molWeightError = 0.0f;
        this.method = MassSpectrometryMethod.UNKNOWN;
        for (MassSpectrometryCommentSource massSpectrometryCommentSource : copy.getSources()) {
            MassSpectrometryCommentSource o = DefaultCommentFactory.getInstance().buildMassSpectrometryCommentSource(massSpectrometryCommentSource);
            this.massSpectrometryCommentSources.add(o);
        }
        if (copy.getNote() != null) {
            this.note = DefaultCommentFactory.getInstance().buildMassSpectrometryCommentNote(copy.getNote());
        }
        this.molWeight = copy.getMolWeight();
        this.molWeightError = copy.getMolWeightError();
        if (copy.getMethod() != null) {
            this.method = copy.getMethod();
        }
    }

    @Override
    public float getMolWeightError() {
        return this.molWeightError;
    }

    @Override
    public void setMolWeightError(float molWeightError) {
        this.molWeightError = molWeightError;
    }

    @Override
    public float getMolWeight() {
        return this.molWeight;
    }

    @Override
    public void setMolWeight(float molWeight) {
        this.molWeight = molWeight;
    }

    @Override
    public MassSpectrometryCommentNote getNote() {
        return this.note;
    }

    @Override
    public boolean hasNote() {
        return this.note != null;
        {
        }
    }

    @Override
    public void setNote(MassSpectrometryCommentNote note) {
        if (note == null) {
            throw new IllegalArgumentException();
        }
        this.note = note;
    }

    @Override
    public MassSpectrometryMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(MassSpectrometryMethod method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    @Override
    public List<MassSpectrometryCommentSource> getSources() {
        return this.massSpectrometryCommentSources;
    }

    @Override
    public void setSources(List<MassSpectrometryCommentSource> source) {
        this.massSpectrometryCommentSources = source;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        return Collections.emptySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MassSpectrometryCommentImpl other = (MassSpectrometryCommentImpl)obj;
        if (this.massSpectrometryCommentSources == null ? other.massSpectrometryCommentSources != null : !this.massSpectrometryCommentSources.equals(other.massSpectrometryCommentSources)) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        if (Float.floatToIntBits(this.molWeight) != Float.floatToIntBits(other.molWeight)) {
            return false;
        }
        if (Float.floatToIntBits(this.molWeightError) != Float.floatToIntBits(other.molWeightError)) {
            return false;
        }
        return !(this.note == null ? other.note != null : !this.note.equals(other.note));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.massSpectrometryCommentSources == null ? 0 : this.massSpectrometryCommentSources.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + Float.floatToIntBits(this.molWeight);
        result = 31 * result + Float.floatToIntBits(this.molWeightError);
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        return result;
    }

    public String toString() {
        return "MassSpectrometryCommentImpl[, note=" + this.note + ", molWeight=" + this.molWeight + ", molWeightError=" + this.molWeightError + ", method=" + (Object)((Object)this.method) + ", massSpectrometryCommentSources=" + this.massSpectrometryCommentSources + ']';
    }
}

