/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniparc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;

public class UniParcDatabaseCrossReferenceImpl
implements PersistentObject,
DatabaseCrossReference {
    private static final long serialVersionUID = -8053480751411375267L;
    private static DateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy");
    private Database db;
    private String accession;
    private int version;
    private boolean active;
    private Date created;
    private Date updated;
    private boolean deleted;
    private String chain;
    private String uniProtAccession;
    private int internalVersion;
    private String giNumber;
    private int taxonomyId;
    private List<Integer> extraTaxonomyIds = new ArrayList<Integer>();
    private String proteinName;
    private String geneName;
    private String proteome;
    private String proteomeComponent;
    public long id;

    public UniParcDatabaseCrossReferenceImpl() {
        this.active = false;
        this.deleted = false;
        this.created = new Date();
        this.updated = new Date();
        this.db = DefaultUniParcFactory.getInstance().buildDatabase();
        this.accession = "";
        this.version = -1;
        this.chain = "";
        this.uniProtAccession = "";
        this.internalVersion = -1;
        this.giNumber = "";
        this.taxonomyId = -1;
        this.proteinName = "";
        this.geneName = "";
        this.proteome = null;
    }

    public UniParcDatabaseCrossReferenceImpl(DatabaseCrossReference copy) {
        this.db = DefaultUniParcFactory.getInstance().buildDatabase(copy.getDatabase());
        this.accession = copy.getAccession();
        this.version = copy.getVersion();
        this.active = copy.isActive();
        this.created = copy.getCreated();
        this.updated = copy.getUpdated();
        this.deleted = !copy.isActive();
        this.chain = copy.getChain();
        this.uniProtAccession = copy.getUniProtAccession();
        this.internalVersion = copy.getInternalVersion();
        this.giNumber = copy.getGiNumber();
        this.taxonomyId = copy.getTaxonomyId();
        this.extraTaxonomyIds.addAll(copy.getExtraTaxonomyIds());
        this.proteinName = copy.getProteinName();
        this.geneName = copy.getGeneName();
        this.proteome = copy.getProteome();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getTaxonomyId() {
        return this.taxonomyId;
    }

    @Override
    public void setTaxonomyId(int taxonomyId) {
        this.taxonomyId = taxonomyId;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.typeOf(this.db.getName());
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void setDatabase(Database db) {
        if (db == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.db = db;
    }

    @Override
    public String getAccession() {
        return this.accession;
    }

    @Override
    public void setAccession(String ac) {
        if (ac == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.accession = ac;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Date createdDate) {
        if (createdDate == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.created = createdDate;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Date updatedDate) {
        if (updatedDate == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.updated = updatedDate;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public String getChain() {
        return this.chain;
    }

    @Override
    public void setChain(String chain) {
        if (chain == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.chain = chain;
    }

    @Override
    public String getUniProtAccession() {
        return this.uniProtAccession;
    }

    @Override
    public void setUniProtAccession(String uniProtAccession) {
        if (uniProtAccession == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.uniProtAccession = uniProtAccession;
    }

    @Override
    public int getInternalVersion() {
        return this.internalVersion;
    }

    @Override
    public void setInternalVersion(int internalVersion) {
        this.internalVersion = internalVersion;
    }

    @Override
    public String getGiNumber() {
        return this.giNumber;
    }

    @Override
    public void setGiNumber(String giNumber) {
        if (giNumber == null) {
            throw new IllegalArgumentException("Please set a non null value");
        }
        this.giNumber = giNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.db.getName()).append(":");
        sb.append(this.getAccession()).append(";");
        sb.append(this.chain).append(";");
        sb.append(this.getGiNumber()).append(";");
        sb.append(this.getVersion()).append(";");
        sb.append(this.getProteinName()).append(";");
        sb.append(this.getGeneName()).append(";");
        sb.append(this.getTaxonomyId());
        for (int val : this.getExtraTaxonomyIds()) {
            sb.append(",").append(val);
        }
        sb.append(".");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniParcDatabaseCrossReferenceImpl that = (UniParcDatabaseCrossReferenceImpl)o;
        if (this.active != that.active) {
            return false;
        }
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.internalVersion != that.internalVersion) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.accession != null ? !this.accession.equals(that.accession) : that.accession != null) {
            return false;
        }
        if (this.chain != null ? !this.chain.equals(that.chain) : that.chain != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.db != null ? !this.db.equals(that.db) : that.db != null) {
            return false;
        }
        if (this.giNumber != null ? !this.giNumber.equals(that.giNumber) : that.giNumber != null) {
            return false;
        }
        if (this.uniProtAccession != null ? !this.uniProtAccession.equals(that.uniProtAccession) : that.uniProtAccession != null) {
            return false;
        }
        if (this.updated != null ? !this.updated.equals(that.updated) : that.updated != null) {
            return false;
        }
        if (this.proteinName != null ? !this.proteinName.equals(that.proteinName) : that.proteinName != null) {
            return false;
        }
        if (this.geneName != null ? !this.geneName.equals(that.geneName) : that.geneName != null) {
            return false;
        }
        if (!this.isEquals(this.extraTaxonomyIds, that.extraTaxonomyIds)) {
            return false;
        }
        if (this.proteome != null ? !this.proteome.equals(that.proteome) : that.proteome != null) {
            return false;
        }
        return !(this.proteomeComponent != null ? !this.proteomeComponent.equals(that.proteomeComponent) : that.proteomeComponent != null);
    }

    private <T> boolean isEquals(List<T> s1, List<T> s2) {
        T o;
        int i;
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return s1 == null;
        }
        if (s1.size() != s2.size()) {
            return false;
        }
        for (i = 0; i < s1.size(); ++i) {
            o = s1.get(i);
            if (s2.contains(o)) continue;
            return false;
        }
        for (i = 0; i < s2.size(); ++i) {
            o = s2.get(i);
            if (s1.contains(o)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.db != null ? this.db.hashCode() : 0;
        result = 31 * result + (this.accession != null ? this.accession.hashCode() : 0);
        result = 31 * result + this.version;
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.updated != null ? this.updated.hashCode() : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.chain != null ? this.chain.hashCode() : 0);
        result = 31 * result + (this.uniProtAccession != null ? this.uniProtAccession.hashCode() : 0);
        result = 31 * result + this.internalVersion;
        result = 31 * result + (this.giNumber != null ? this.giNumber.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.proteinName != null ? this.proteinName.hashCode() : 0);
        result = 31 * result + (this.geneName != null ? this.geneName.hashCode() : 0);
        result = 31 * result + (this.extraTaxonomyIds != null ? this.extraTaxonomyIds.hashCode() : 0);
        result = 31 * result + (this.proteome != null ? this.proteome.hashCode() : 0);
        result = 31 * result + (this.proteomeComponent != null ? this.proteomeComponent.hashCode() : 0);
        return result;
    }

    @Override
    public List<Integer> getExtraTaxonomyIds() {
        return this.extraTaxonomyIds;
    }

    @Override
    public void setExtraTaxonomyIds(List<Integer> taxonIds) {
        this.extraTaxonomyIds = taxonIds;
    }

    @Override
    public String getProteinName() {
        return this.proteinName;
    }

    @Override
    public void setProteinName(String proteinName) {
        this.proteinName = proteinName;
    }

    @Override
    public String getGeneName() {
        return this.geneName;
    }

    @Override
    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    @Override
    public String getProteome() {
        return this.proteome;
    }

    @Override
    public void setProteome(String proteome) {
        this.proteome = proteome;
    }

    @Override
    public void setProteomeComponent(String component) {
        this.proteomeComponent = component;
    }

    @Override
    public String getProteomeComponent() {
        return this.proteomeComponent;
    }
}

