/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.factories.UniMesFactory;
import uk.ac.ebi.kraken.interfaces.unimes.Organism;
import uk.ac.ebi.kraken.interfaces.unimes.PeptideId;
import uk.ac.ebi.kraken.interfaces.unimes.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.unimes.UniMesAccession;
import uk.ac.ebi.kraken.interfaces.unimes.UniMesEntry;
import uk.ac.ebi.kraken.model.factories.DefaultEntryFactory;
import uk.ac.ebi.kraken.model.unimes.OrganismImpl;
import uk.ac.ebi.kraken.model.unimes.PeptideIdImpl;
import uk.ac.ebi.kraken.model.unimes.ProteinDescriptionImpl;
import uk.ac.ebi.kraken.model.unimes.UniMesAccessionImpl;
import uk.ac.ebi.kraken.model.unimes.UniMesDatabaseImpl;
import uk.ac.ebi.kraken.model.unimes.UniMesEntryImpl;

public class DefaultUniMesFactory
extends DefaultEntryFactory
implements UniMesFactory {
    private static DefaultUniMesFactory singletonInstance;

    protected DefaultUniMesFactory() {
    }

    public static DefaultUniMesFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultUniMesFactory();
        }
        return singletonInstance;
    }

    @Override
    public Database buildDatabase() {
        return new UniMesDatabaseImpl();
    }

    @Override
    public UniMesEntry buildEntry() {
        return new UniMesEntryImpl();
    }

    @Override
    public PeptideId buildPeptideId(String peptideId) {
        PeptideIdImpl result = new PeptideIdImpl();
        result.setValue(peptideId);
        return result;
    }

    @Override
    public ProteinDescription buildProteinDescription(String proteinDescription) {
        ProteinDescriptionImpl result = new ProteinDescriptionImpl();
        result.setValue(proteinDescription);
        return result;
    }

    @Override
    public UniMesAccession buildUniMesAccession(String acc) {
        UniMesAccessionImpl result = new UniMesAccessionImpl();
        result.setValue(acc);
        return result;
    }

    @Override
    public Organism buildOrganism(String organism) {
        OrganismImpl result = new OrganismImpl();
        result.setValue(organism);
        return result;
    }
}

