/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.comments;

public enum MichaelisConstantUnit {
    MOL("M"),
    MILLI_MOL("mM"),
    MICRO_MOL("uM"),
    NANO_MOL("nM"),
    MG_ML_2("mg/mL"),
    MG_ML("mg/ml");

    private String name;

    private MichaelisConstantUnit(String name) {
        this.name = name;
    }

    public static MichaelisConstantUnit convert(String unit) {
        for (MichaelisConstantUnit value : MichaelisConstantUnit.values()) {
            if (!value.name.equals(unit)) continue;
            return value;
        }
        throw new RuntimeException("unknown Michaelis Constant Unit: " + unit);
    }

    public String getName() {
        return this.name();
    }

    public String getDisplayString() {
        return this.toDisplayNameString();
    }

    public String toDisplayNameString() {
        return this.name;
    }
}

