/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RALineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RGLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RPLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RTLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RXLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;

public class RLineBuilder
extends FFLineBuilderAbstr<Citation>
implements FFLineBuilder<Citation> {
    private static final RPLineBuilder RP_LINE_BUILDER = new RPLineBuilder();
    private static final RCLineBuilder RC_LINE_BUILDER = new RCLineBuilder();
    private static final RXLineBuilder RX_LINE_BUILDER = new RXLineBuilder();
    private static final RGLineBuilder RG_LINE_BUILDER = new RGLineBuilder();
    private static final RALineBuilder RA_LINE_BUILDER = new RALineBuilder();
    private static final RTLineBuilder RT_LINE_BUILDER = new RTLineBuilder();
    private static final RLLineBuilder RL_LINE_BUILDER = new RLLineBuilder();
    private int rn;

    public RLineBuilder() {
        super(LineType.RN);
    }

    public void setRN(int rn) {
        this.rn = rn;
    }

    @Override
    public String buildString(Citation f) {
        return this.buildLine(f, false, false).toString();
    }

    @Override
    public String buildStringWithEvidence(Citation f) {
        return this.buildLine(f, false, true).toString();
    }

    @Override
    protected FFLine buildLine(Citation f, boolean showEvidence) {
        return this.buildLine(f, true, showEvidence);
    }

    private FFLine buildLine(Citation f, boolean includeFFMarkup, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.buildRNLine(this.rn, f, includeFFMarkup, showEvidence));
        lines.addAll(RP_LINE_BUILDER.buildLine(f.getCitationSummary(), includeFFMarkup, showEvidence));
        lines.addAll(RC_LINE_BUILDER.buildLine(f.getSampleSources(), includeFFMarkup, showEvidence));
        lines.addAll(RX_LINE_BUILDER.buildLine(f.getCitationXrefs(), includeFFMarkup, showEvidence));
        lines.addAll(RG_LINE_BUILDER.buildLine(f.getAuthoringGroup(), includeFFMarkup, showEvidence));
        lines.addAll(RA_LINE_BUILDER.buildLine(f.getAuthors(), includeFFMarkup, showEvidence));
        lines.addAll(RT_LINE_BUILDER.buildLine(f.getTitle(), includeFFMarkup, showEvidence));
        lines.addAll(RL_LINE_BUILDER.buildLine(f, includeFFMarkup, showEvidence));
        return FFLines.create(lines);
    }

    private List<String> buildRNLine(int rn, HasEvidences he, boolean includeFFMarkup, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        String rnLinePrefix = (Object)((Object)LineType.RN) + "   ";
        if (includeFFMarkup) {
            sb.append(rnLinePrefix);
        }
        String rnStr = "[" + rn + "]";
        sb.append(rnStr);
        this.addEvidences(sb, he, showEvidence);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(sb.toString());
        return lines;
    }
}

