/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.util.SignificantDigitHelper;

public class MassSpecCCLineBuilder
extends CCLineBuilderAbstr<MassSpectrometryComment> {
    private static final String EVIDENCE = "Evidence=";
    private static final String RANGE2 = "Range=";
    private static final String METHOD = "Method=";
    private static final String MASS_ERROR = "Mass_error=";
    private static final String MASS = "Mass=";

    @Override
    protected List<String> buildCommentLines(MassSpectrometryComment comment, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("");
        if (includeFlatFileMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFlatFileMarkings, sb);
        }
        sb.append(comment.getCommentType().toDisplayName());
        sb.append(": ");
        this.addMolecule(comment, sb, true);
        sb.append(MASS);
        sb.append(SignificantDigitHelper.getSigDig(comment.getMolWeight()));
        if ((double)Math.abs(comment.getMolWeightError()) > 4.9E-323) {
            sb.append("; ");
            sb.append(MASS_ERROR);
            sb.append(SignificantDigitHelper.getSigDig(comment.getMolWeightError()));
        }
        sb.append("; ");
        sb.append(METHOD);
        sb.append(comment.getMethod().getValue());
        sb.append(";");
        if (comment.getNote() != null && comment.getNote().getValue().length() > 0) {
            sb.append(" ");
            sb.append("Note=");
            sb.append(comment.getNote().getValue());
            sb.append(";");
        }
        if (comment.getSources() != null && !comment.getSources().isEmpty()) {
            sb.append(" ");
            sb.append(EVIDENCE);
            sb.append("{");
            for (int i = 0; i < comment.getSources().size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                MassSpectrometryCommentSource source = comment.getSources().get(i);
                sb.append(source);
            }
            sb.append("}");
            sb.append(";");
        } else if (showEvidence && !comment.getEvidenceIds().isEmpty()) {
            sb.append(" ");
            sb.append(EVIDENCE);
            String evStr = EvidenceLine.export(comment.getEvidenceIds()).trim();
            sb.append(evStr).append(";");
        }
        if (includeFlatFileMarkings) {
            lines.addAll(FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80));
        } else {
            lines.add(sb.toString());
        }
        return lines;
    }
}

