/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;

public class OHLineBuilder
extends FFLineBuilderAbstr<List<OrganismHost>>
implements FFLineBuilder<List<OrganismHost>> {
    private static final String NCBI_TAX_ID = "NCBI_TaxID=";
    private static final Comparator<OrganismHost> comparator = (o1, o2) -> o1.getOrganism().getScientificName().getValue().compareTo(o2.getOrganism().getScientificName().getValue());

    public OHLineBuilder() {
        super(LineType.OH);
    }

    @Override
    protected FFLine buildLine(List<OrganismHost> organismHosts, boolean showEvidence) {
        List f = organismHosts.stream().sorted(comparator).collect(Collectors.toList());
        ArrayList<String> lls = new ArrayList<String>();
        for (OrganismHost oh : f) {
            lls.add(this.build(oh, showEvidence, true).toString());
        }
        return FFLines.create(lls);
    }

    @Override
    public String buildString(List<OrganismHost> f) {
        StringBuilder sb = new StringBuilder();
        for (OrganismHost oh : f) {
            sb.append((CharSequence)this.build(oh, false, false));
        }
        return sb.toString();
    }

    @Override
    public String buildStringWithEvidence(List<OrganismHost> f) {
        StringBuilder sb = new StringBuilder();
        for (OrganismHost oh : f) {
            sb.append((CharSequence)this.build(oh, true, false));
        }
        return sb.toString();
    }

    private StringBuilder build(OrganismHost organismHost, boolean showEvidence, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        sb.append(NCBI_TAX_ID);
        sb.append(organismHost.getNcbiTaxonomyId().getValue());
        sb.append("; ");
        Organism organism = organismHost.getOrganism();
        if (organism != null) {
            if (organism.getScientificName() != null) {
                sb.append(organism.getScientificName().getValue());
            }
            if (organism.getCommonName() != null && !organism.getCommonName().getValue().equals("")) {
                sb.append(" (");
                sb.append(organism.getCommonName().getValue());
                sb.append(")");
            }
            if (organism.getSynonym() != null && !organism.getSynonym().getValue().equals("")) {
                sb.append(" (");
                sb.append(organism.getSynonym());
                sb.append(")");
            }
        }
        sb.append(".");
        return sb;
    }
}

