/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.text.SimpleDateFormat;
import java.util.Locale;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.util.thread.SimpleDateFormatThreadSafe;

public abstract class FFLineBuilderAbstr<T>
implements FFLineBuilder<T> {
    protected final SimpleDateFormat dateFormatter = new SimpleDateFormatThreadSafe("dd-MMM-yyyy", Locale.ENGLISH);
    protected final LineType lineType;
    protected final String linePrefix;

    protected abstract FFLine buildLine(T var1, boolean var2);

    public FFLineBuilderAbstr(LineType lineType) {
        this(lineType, "   ");
    }

    public FFLineBuilderAbstr(LineType lineType, String linespace) {
        this.lineType = lineType;
        this.linePrefix = (Object)((Object)lineType) + linespace;
    }

    @Override
    public FFLine build(T f) {
        return this.buildLine(f, false);
    }

    @Override
    public FFLine buildWithEvidence(T f) {
        return this.buildLine(f, true);
    }

    protected StringBuilder addEvidences(StringBuilder sb, HasEvidences he, boolean showEvidence) {
        if (!showEvidence) {
            return sb;
        }
        sb.append(EvidenceLine.export(he.getEvidenceIds()));
        return sb;
    }

    protected void appendIfNot(StringBuilder sb, char c) {
        if (sb.charAt(sb.length() - 1) != c) {
            sb.append(c);
        }
    }

    protected void appendIfNot(StringBuilder sb, String c) {
        if (!sb.toString().endsWith(c)) {
            sb.append(c);
        }
    }
}

