/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;

public class DELineBuilder
extends FFLineBuilderAbstr<ProteinDescription>
implements FFLineBuilder<ProteinDescription> {
    private static final int LINE_LENGTH = 254;
    private static final String FLAGS = "Flags: ";
    private static final String CONTAINS = "Contains:";
    private static final String INCLUDES = "Includes:";
    private static final String REC_NAME = "RecName: ";
    private static final String DE_LINE_SPACE = "         ";
    private static final String DE_PREFIX_2 = "DE     ";
    private static final String SUB_NAME = "SubName: ";
    private static final String ALT_NAME = "AltName: ";

    public DELineBuilder() {
        super(LineType.DE);
    }

    @Override
    public String buildString(ProteinDescription f) {
        List<String> lines = this.buildLines(f, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(ProteinDescription f) {
        List<String> lines = this.buildLines(f, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(ProteinDescription f, boolean showEvidence) {
        List<String> lines = this.buildLines(f, true, showEvidence);
        return FFLines.create(lines);
    }

    private List<String> buildLines(ProteinDescription description, boolean includeFlatFileMarkings, boolean addEvidence) {
        ArrayList<String> deLines = new ArrayList<String>();
        if (description.hasRecommendedName()) {
            deLines.addAll(this.buildNameLine(description.getRecommendedName(), REC_NAME, this.linePrefix, includeFlatFileMarkings, addEvidence));
        }
        if (description.hasAlternativeNames()) {
            for (Name name : description.getAlternativeNames()) {
                deLines.addAll(this.buildNameLine(name, ALT_NAME, this.linePrefix, includeFlatFileMarkings, addEvidence));
            }
        }
        if (description.hasSubNames()) {
            for (Name name : description.getSubNames()) {
                deLines.addAll(this.buildNameLine(name, SUB_NAME, this.linePrefix, includeFlatFileMarkings, addEvidence));
            }
        }
        for (Section section : description.getIncludes()) {
            deLines.addAll(this.buildSectionLines(section, INCLUDES, includeFlatFileMarkings, addEvidence));
        }
        for (Section section : description.getContains()) {
            deLines.addAll(this.buildSectionLines(section, CONTAINS, includeFlatFileMarkings, addEvidence));
        }
        if (!description.getFlags().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (includeFlatFileMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append(FLAGS);
            boolean isfirst = true;
            for (Flag type : description.getFlags()) {
                if (!isfirst) {
                    sb.append(" ");
                }
                sb.append(type.getFlagType().getValue());
                this.addEvidences(sb, type, addEvidence);
                sb.append(";");
                isfirst = false;
            }
            deLines.add(sb.toString());
        }
        return deLines;
    }

    private List<String> buildNameLine(Name name, String type, String deLinePrefix, boolean includeFlatFileMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = true;
        for (Field field : name.getFields()) {
            StringBuilder sb = new StringBuilder();
            if (includeFlatFileMarkings) {
                sb.append(deLinePrefix);
            }
            if (first) {
                sb.append(type);
            } else {
                sb.append(DE_LINE_SPACE);
            }
            sb.append(field.getType().getValue()).append("=").append(field.getValue());
            if (showEvidence) {
                String evString = EvidenceLine.export(field.getEvidenceIds());
                int length = 254 - evString.length() - 3;
                sb = this.trimString(sb, length);
                sb.append(evString);
            } else {
                sb = this.trimString(sb, 254);
            }
            sb.append(";");
            first = false;
            lines.add(sb.toString());
        }
        return lines;
    }

    private StringBuilder trimString(StringBuilder val, int maxLength) {
        if (val.length() <= maxLength) {
            return val;
        }
        String result = val.toString();
        int index = maxLength;
        for (int i = maxLength; i >= 0; --i) {
            char c = result.charAt(i);
            if (c != ' ' && c != ',') continue;
            index = i;
            if (result.charAt(index - 1) != '.') break;
            --index;
            break;
        }
        result = result.substring(0, index);
        return new StringBuilder(result + "...");
    }

    private List<String> buildSectionLines(Section section, String sectionType, boolean includeFlatFileMarkings, boolean addEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb1 = new StringBuilder();
        if (includeFlatFileMarkings) {
            sb1.append(this.linePrefix);
        }
        sb1.append(sectionType);
        lines.add(sb1.toString());
        if (!section.getNamesByType(NameType.RECNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.RECNAME)) {
                lines.addAll(this.buildNameLine(name, REC_NAME, DE_PREFIX_2, includeFlatFileMarkings, addEvidence));
            }
        }
        if (!section.getNamesByType(NameType.ALTNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.ALTNAME)) {
                lines.addAll(this.buildNameLine(name, ALT_NAME, DE_PREFIX_2, includeFlatFileMarkings, addEvidence));
            }
        }
        if (!section.getNamesByType(NameType.SUBNAME).isEmpty()) {
            for (Name name : section.getNamesByType(NameType.SUBNAME)) {
                lines.addAll(this.buildNameLine(name, SUB_NAME, DE_PREFIX_2, includeFlatFileMarkings, addEvidence));
            }
        }
        return lines;
    }
}

