/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line;

import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;

public class EvidenceLine {
    private static final String SEPARATOR1 = ",";
    private static final String SEPARATOR2 = ", ";

    public static String export(List<EvidenceId> evIds) {
        return EvidenceLine.export(evIds, true);
    }

    public static String export(List<EvidenceId> evIds, boolean withBracket) {
        String s = "";
        Collections.sort(evIds);
        boolean first = true;
        boolean isEco = false;
        for (EvidenceId evid : evIds) {
            if (evid.getValue().startsWith("ECO")) {
                isEco = true;
            }
            if (!first) {
                s = evid.getValue().startsWith("ECO") ? s + SEPARATOR2 : s + SEPARATOR1;
            }
            s = s + evid.getValue();
            first = false;
        }
        if (s.length() > 0 && withBracket) {
            s = isEco ? " {" + s + "}" : "{" + s + "}";
        }
        return s;
    }
}

