/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class OrganelleHelper {
    private static String stripEvidenceIds(String line, List<EvidenceId> evidences) {
        if (line.endsWith("}")) {
            String ev = line.substring(line.lastIndexOf(123) + 1, line.lastIndexOf(125));
            StringTokenizer st = new StringTokenizer(ev, ",");
            while (st.hasMoreTokens()) {
                evidences.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(st.nextToken()));
            }
        } else {
            return line;
        }
        return line.substring(0, line.lastIndexOf(123));
    }

    public static void addOg(String in, UniProtEntry entry) {
        ArrayList<Organelle> lineOrg = new ArrayList<Organelle>();
        String line = in.trim();
        if (line.length() > 0) {
            if ((line = line.endsWith(", and") ? line.substring(0, line.length() - 5) : line.substring(0, line.length() - 1)).startsWith("Chloroplast") || line.startsWith("Plastid; Chloroplast")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CHLOROPLAST_PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Mitochondrion")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.MITOCHONDRION);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Hydrogenosome")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.HYDROGENOSOME);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Nucleomorph")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.NUCLEOMORPH);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.equalsIgnoreCase("Plastid") || line.startsWith("Plastid{")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Apicoplast") || line.startsWith("Plastid; Apicoplast")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.APICOPLAST_PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Cyanelle") || line.startsWith("Plastid; Cyanelle")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CYANELLE_PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Non-photosynthetic plastid") || line.startsWith("Plastid; Non-photosynthetic plastid")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.NON_PHOTOSYNTHETIC_PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else if (line.startsWith("Organellar chromatophore") || line.startsWith("Plastid; Organellar chromatophore")) {
                Organelle org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CHROMATOPHORE_PLASTID);
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                OrganelleHelper.stripEvidenceIds(line, evidences);
                org.setEvidenceIds(evidences);
                lineOrg.add(0, org);
            } else {
                Organelle org;
                ArrayList<EvidenceId> ev2;
                String plasmid;
                Organelle org2;
                int commaAnd = line.lastIndexOf(", and Plasmid");
                if (commaAnd != -1) {
                    if (line.endsWith(", and Plasmid")) {
                        org2 = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID, "");
                        lineOrg.add(0, org2);
                    } else {
                        plasmid = line.substring(commaAnd + 13).trim();
                        ev2 = new ArrayList<EvidenceId>();
                        plasmid = OrganelleHelper.stripEvidenceIds(plasmid, ev2);
                        org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID, plasmid);
                        org.setEvidenceIds(ev2);
                        lineOrg.add(0, org);
                    }
                    line = line.substring(0, commaAnd).trim();
                }
                while ((commaAnd = line.lastIndexOf(", Plasmid")) != -1) {
                    plasmid = line.substring(commaAnd + 10).trim();
                    ev2 = new ArrayList();
                    plasmid = OrganelleHelper.stripEvidenceIds(plasmid, ev2);
                    org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID, plasmid);
                    org.setEvidenceIds(ev2);
                    lineOrg.add(0, org);
                    line = line.substring(0, commaAnd).trim();
                }
                if (line.equalsIgnoreCase("Plasmid")) {
                    org2 = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID, "");
                    ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                    org2.setEvidenceIds(evidences);
                    lineOrg.add(0, org2);
                } else {
                    plasmid = line.substring(7).trim();
                    ev2 = new ArrayList();
                    plasmid = OrganelleHelper.stripEvidenceIds(plasmid, ev2);
                    org = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID, plasmid);
                    org.setEvidenceIds(ev2);
                    lineOrg.add(0, org);
                }
            }
        }
        entry.getOrganelles().addAll(lineOrg);
    }

    public static String toSwissprotString(Organelle organelle) {
        StringBuilder sb = new StringBuilder();
        switch (organelle.getType()) {
            case UNKOWN: {
                break;
            }
            case HYDROGENOSOME: {
                sb.append(organelle.getType().getValue());
                break;
            }
            case MITOCHONDRION: {
                sb.append(organelle.getType().getValue());
                break;
            }
            case NUCLEOMORPH: {
                sb.append(organelle.getType().getValue());
                break;
            }
            case PLASMID: {
                sb.append(organelle.getType().getValue());
                if (organelle.getValue() == null || organelle.getValue().equals("")) break;
                sb.append(" ");
                sb.append(organelle.getValue());
                break;
            }
            case PLASTID: {
                sb.append(organelle.getType().getValue());
                break;
            }
            case APICOPLAST_PLASTID: 
            case CHLOROPLAST_PLASTID: 
            case CYANELLE_PLASTID: 
            case NON_PHOTOSYNTHETIC_PLASTID: 
            case CHROMATOPHORE_PLASTID: {
                sb.append("Plastid; ");
                sb.append(organelle.getType().getValue());
            }
        }
        return sb.toString();
    }
}

