/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.List;
import uk.ac.ebi.kraken.ffwriter.FastaWriter;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;

public class UniprotFasta {
    private final String header;
    private final String sequence;
    private static final String SP = "sp";
    private static final String TR = "tr";

    public static UniprotFasta create(UniProtEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append('>');
        if (entry.getType() == UniProtEntryType.SWISSPROT) {
            sb.append(SP);
        } else {
            sb.append(TR);
        }
        sb.append('|');
        sb.append(entry.getPrimaryUniProtAccession().getValue());
        sb.append('|');
        sb.append(entry.getUniProtId().getValue());
        sb.append(' ').append(UniprotFasta.getDescriptionStr(entry.getProteinDescription()));
        sb.append(" OS=").append(entry.getOrganism().getScientificName().getValue());
        sb.append(" OX=").append(entry.getNcbiTaxonomyIds().get(0).getValue());
        String geneStr = UniprotFasta.getGeneStr(entry.getGenes());
        if (geneStr != null) {
            sb.append(" GN=").append(geneStr);
        }
        sb.append(" PE=").append(UniprotFasta.getProteinExist(entry));
        sb.append(" SV=").append(entry.getEntryAudit().getSequenceVersion());
        return new UniprotFasta(sb.toString(), entry.getSequence().getValue());
    }

    private UniprotFasta(String header, String sequence) {
        this.header = header;
        this.sequence = sequence;
    }

    private static String getProteinExist(UniProtEntry entry) {
        ProteinExistence pe = entry.getProteinExistence();
        String peStr = "5";
        if (pe == ProteinExistence.PROTEIN_LEVEL) {
            peStr = "1";
        } else if (pe == ProteinExistence.TRANSCRIPT_LEVEL) {
            peStr = "2";
        } else if (pe == ProteinExistence.HOMOLOGY) {
            peStr = "3";
        } else if (pe == ProteinExistence.PREDICTED) {
            peStr = "4";
        } else if (pe == ProteinExistence.UNCERTAIN) {
            peStr = "5";
        }
        return peStr;
    }

    public static String getGeneStr(List<Gene> genes) {
        String geneName = null;
        String orfName = null;
        String olnName = null;
        for (Gene gene : genes) {
            if (gene.hasGeneName()) {
                geneName = gene.getGeneName().getValue();
                continue;
            }
            if (gene.getOrderedLocusNames() != null && !gene.getOrderedLocusNames().isEmpty()) {
                olnName = gene.getOrderedLocusNames().get(0).getValue();
                continue;
            }
            if (gene.getORFNames() == null || gene.getORFNames().isEmpty()) continue;
            orfName = gene.getORFNames().get(0).getValue();
        }
        if (geneName != null) {
            return geneName;
        }
        if (olnName != null) {
            return olnName;
        }
        return orfName;
    }

    public static String getDescriptionStr(ProteinDescription pd) {
        StringBuilder desc = new StringBuilder();
        Name name = pd.hasRecommendedName() ? pd.getRecommendedName() : pd.getSubNames().get(0);
        desc.append(name.getFieldsByType(FieldType.FULL).get(0).getValue());
        List<Flag> flags = pd.getFlags();
        String fragment = null;
        if (flags != null && !flags.isEmpty()) {
            for (Flag flag : flags) {
                if (flag.getFlagType() != FlagType.FRAGMENT) continue;
                fragment = flag.getFlagType().getValue();
                break;
            }
        }
        if (fragment != null) {
            desc.append(" (");
            desc.append(fragment);
            desc.append(")");
        }
        return desc.toString();
    }

    public String getHeader() {
        return this.header;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header).append("\n");
        sb.append(FastaWriter.toFastaBody(this.sequence));
        return sb.toString();
    }
}

