/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.transformation.sequencesgroup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class GetOrfSequencesGroupTransformation
implements SequencesGroupTransformation {
    public static final int DEFAULT_MIN_SIZE = 30;
    public static final int DEFAULT_MAX_SIZE = 10000;
    private int table;
    private int minSize;
    private int maxSize;
    private int find;
    private final DatatypeFactory factory;
    private String additionalParameters;
    private EmbossBinariesExecutor embossBinariesExecutor;

    public GetOrfSequencesGroupTransformation(EmbossBinariesExecutor embossBinariesExecutor, int table, int minSize, int maxSize, int find, String additionalParameters) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), embossBinariesExecutor, table, minSize, maxSize, find, additionalParameters);
    }

    public GetOrfSequencesGroupTransformation(DatatypeFactory factory, EmbossBinariesExecutor embossBinariesExecutor, int table, int minSize, int maxSize, int find, String additionalParameters) {
        this.embossBinariesExecutor = embossBinariesExecutor;
        this.factory = factory;
        this.table = table;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.find = find;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        try {
            return this.getOrf(sequencesGroup, this.factory);
        }
        catch (IOException | InterruptedException e) {
            throw new TransformationException("Error while running EMBOSS getorf." + e.getMessage());
        }
    }

    private SequencesGroup getOrf(SequencesGroup sequencesGroup, DatatypeFactory factory) throws IOException, InterruptedException {
        Path fastaFile = Files.createTempFile(sequencesGroup.getName(), "fasta", new FileAttribute[0]);
        FastaWriter.writeFasta(fastaFile, sequencesGroup.getSequences());
        Path alignedFile = Files.createTempFile(sequencesGroup.getName() + "_aligned", ".fasta", new FileAttribute[0]);
        this.embossBinariesExecutor.getOrf(fastaFile.toFile(), alignedFile.toFile(), this.table, this.minSize, this.maxSize, this.find, this.additionalParameters);
        List<Sequence> alignedSequences = factory.newSequencesGroup(alignedFile).getSequences().collect(Collectors.toList());
        return factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), alignedSequences);
    }
}

