/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.cga.gui.CgaPipelineTransformationConfigurationPanel;
import org.sing_group.seda.cga.plugin.core.CgaPipelineSedaPluginInfo;
import org.sing_group.seda.cga.transformation.provider.CgaPipelineTransformationProvider;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class CgaPipelineSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private CgaPipelineTransformationConfigurationPanel panel = new CgaPipelineTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "Conserved Genome Annotation (CGA) Pipeline";
    }

    @Override
    public String getGroupName() {
        return CgaPipelineSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Obtain CDS annotations with CGA, using selected files and a FASTA file with the reference sequence.";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<CgaPipelineTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((CgaPipelineTransformationProvider)new JsonObjectReader().read(file, CgaPipelineTransformationProvider.class));
    }
}

