/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.DefaultDockerCgaBinariesChecker;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;

@XmlRootElement
public class DefaultDockerCgaBinariesExecutor
extends AbstractBinariesExecutor
implements CgaBinariesExecutor {
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DefaultDockerCgaBinariesExecutor() {
        this(DefaultDockerCgaBinariesExecutor.getDefaultDockerImage());
    }

    public DefaultDockerCgaBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    public void initWorkingDir(File workingDir, String ... removeFiles) throws IOException, InterruptedException {
        workingDir.mkdirs();
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(workingDir.getAbsolutePath());
        super.executeCommand(this.composeCommand("docker run --rm", DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount), this.dockerImage, "init_working_dir.sh", workingDir.getAbsolutePath()));
        List<String> removeFilesList = Arrays.asList(removeFiles);
        if (!removeFilesList.isEmpty()) {
            super.executeCommand(this.composeCommand("docker run --rm --entrypoint=/usr/bin/rm", DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount), this.dockerImage, removeFilesList.stream().map(file -> workingDir.getAbsolutePath() + "/" + file).collect(Collectors.joining(" "))));
        }
    }

    @Override
    public void run(File workingDir, String additionalCompiParameters) throws IOException, InterruptedException {
        super.executeCommand(Arrays.asList(workingDir.getAbsolutePath() + "/run.sh", workingDir.getAbsolutePath(), additionalCompiParameters));
    }

    private List<String> composeCommand(String ... parameters) {
        return Arrays.asList(Arrays.stream(parameters).collect(Collectors.joining(" ")).split(" "));
    }

    public static String getDefaultDockerImage() {
        return "pegi3s/cga";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            DefaultDockerCgaBinariesChecker.checkCgaAvailability(this.dockerImage);
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

