/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.execution;

import java.io.File;
import java.util.Properties;
import org.sing_group.seda.cga.execution.CgaCompiPipelineConfiguration;

public class CgaPipelineParameters
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String HOST_WORKING_DIR = "host_working_dir";
    public static final String MAX_DIST = "max_dist";
    public static final String INTRON_BP = "intron_bp";
    public static final String SELECTION_CRITERION = "selection_criterion";
    public static final String SELECTION_CORRECTION = "selection_correction";
    public static final String MIN_FULL_NUCLEOTIDE_SIZE = "min_full_nucleotide_size";
    public static final String SKIP_PULL_DOCKER_IMAGES = "skip_pull_docker_images";
    private File workingDir;
    private CgaCompiPipelineConfiguration pipelineConfiguration;
    private String additionalCompiParameters;

    public CgaPipelineParameters(File workingDir, CgaCompiPipelineConfiguration pipelineConfiguration, String additionalCompiParameters) {
        this.workingDir = workingDir;
        this.pipelineConfiguration = pipelineConfiguration;
        this.additionalCompiParameters = additionalCompiParameters;
        this.setProperties();
    }

    private void setProperties() {
        this.put(HOST_WORKING_DIR, this.workingDir.getAbsolutePath());
        this.put(MAX_DIST, String.valueOf(this.pipelineConfiguration.getMaxDist()));
        this.put(INTRON_BP, String.valueOf(this.pipelineConfiguration.getIntronBp()));
        this.put(SELECTION_CRITERION, String.valueOf(this.pipelineConfiguration.getSelectionCriterion().getValue()));
        this.put(SELECTION_CORRECTION, String.valueOf(this.pipelineConfiguration.getSelectionCorrection()));
        this.put(MIN_FULL_NUCLEOTIDE_SIZE, String.valueOf(this.pipelineConfiguration.getMinFullNucleotideSize()));
        if (this.pipelineConfiguration.isSkipPullDockerImages()) {
            this.put(SKIP_PULL_DOCKER_IMAGES, "true");
        }
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public String getAdditionalCompiParameters() {
        return this.additionalCompiParameters;
    }
}

