/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class SequencesGroupSortTransformation
implements SequencesGroupTransformation {
    private final boolean descending;
    private final Comparator<? super Sequence> sequencesComparator;
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;

    public SequencesGroupSortTransformation(Comparator<? super Sequence> sequencesComparator) {
        this(sequencesComparator, false);
    }

    public SequencesGroupSortTransformation(Comparator<? super Sequence> sequencesComparator, boolean descending) {
        this(sequencesComparator, descending, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public SequencesGroupSortTransformation(Comparator<? super Sequence> sequencesComparator, boolean descending, DatatypeFactory factory) {
        this.sequencesComparator = sequencesComparator;
        this.descending = descending;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        List<Sequence> newSequences = sequencesGroup.getSequences().sorted(this.descending ? this.sequencesComparator.reversed() : this.sequencesComparator).collect(Collectors.toList());
        return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), newSequences);
    }
}

