/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequence;

import org.sing_group.seda.bio.SequenceUtils;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequence.SequenceTransformation;

public class ReverseComplementSequenceTransformation
implements SequenceTransformation {
    private final SequenceBuilder builder;
    private final boolean reverse;
    private final boolean complement;

    public ReverseComplementSequenceTransformation(boolean reverse, boolean complement) {
        this(reverse, complement, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public ReverseComplementSequenceTransformation(boolean reverse, boolean complement, DatatypeFactory factory) {
        this.reverse = reverse;
        this.complement = complement;
        this.builder = factory::newSequence;
    }

    @Override
    public Sequence transform(Sequence sequence) throws TransformationException {
        String chain = sequence.getChain();
        if (this.complement) {
            chain = SequenceUtils.complement(chain);
        }
        if (this.reverse) {
            chain = SequenceUtils.reverse(chain);
        }
        return this.builder.of(sequence.getName(), sequence.getDescription(), chain, sequence.getProperties());
    }
}

