/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.concatenate;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ConcatenateSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.concatenate.ConcatenateSequencesTransformationChangeType;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

@XmlRootElement
public class ConcatenateSequencesTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private String mergeName;
    @XmlAnyElement(lax=true)
    private HeaderMatcher headerMatcher;
    @XmlElement
    private boolean mergeDescriptions;
    private ReformatFastaTransformationProvider reformatFastaTransformationProvider;
    private TransformationChangeListener reformatFastaTransformationChangeListener = new TransformationChangeListener(){

        @Override
        public void onTransformationChange(TransformationChangeEvent event) {
            ConcatenateSequencesTransformationProvider.this.fireTransformationsConfigurationModelEvent(event);
        }
    };

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.addAll(this.reformatFastaTransformationProvider.validate().getValidationErrors());
        if (!this.isValidMergeName()) {
            errorList.add("The merge name is not valid.");
        }
        if (this.getHeaderMatcher() == null) {
            errorList.add("The regular expression header matcher is not defined.");
        }
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return SequencesGroupDatasetTransformation.concat(new ConcatenateSequencesGroupDatasetTransformation(factory, this.getMergeName(), this.getHeaderMatcher(), this.isMergeDescriptions()), this.reformatFastaTransformationProvider.getTransformation(factory));
    }

    public void setHeaderMatcher(HeaderMatcher headerMatcher) {
        HeaderMatcher oldValue = this.headerMatcher;
        this.headerMatcher = headerMatcher;
        this.fireTransformationsConfigurationModelEvent(ConcatenateSequencesTransformationChangeType.HEADER_MATCHER, oldValue, this.headerMatcher);
    }

    public void removeHeaderMatcher() {
        this.setHeaderMatcher(null);
    }

    public HeaderMatcher getHeaderMatcher() {
        return this.headerMatcher;
    }

    public void setMergeName(String name) {
        String oldValue = this.mergeName;
        this.mergeName = name;
        this.fireTransformationsConfigurationModelEvent(ConcatenateSequencesTransformationChangeType.MERGE_NAME_CHANGED, oldValue, this.mergeName);
    }

    public String getMergeName() {
        return this.mergeName;
    }

    public void setMergeDescriptions(boolean mergeDescriptions) {
        boolean oldValue = this.mergeDescriptions;
        this.mergeDescriptions = mergeDescriptions;
        this.fireTransformationsConfigurationModelEvent(ConcatenateSequencesTransformationChangeType.MERGE_DESCRIPTIONS_CHANGED, oldValue, this.mergeDescriptions);
    }

    public boolean isMergeDescriptions() {
        return this.mergeDescriptions;
    }

    private boolean isValidMergeName() {
        return this.getMergeName() != null && !this.getMergeName().isEmpty();
    }

    public ReformatFastaTransformationProvider getReformatFastaTransformationProvider() {
        return this.reformatFastaTransformationProvider;
    }

    public void setReformatFastaTransformationProvider(ReformatFastaTransformationProvider reformatFastaTransformationProvider) {
        this.reformatFastaTransformationProvider = reformatFastaTransformationProvider;
        this.reformatFastaTransformationProvider.addTransformationChangeListener(this.reformatFastaTransformationChangeListener);
    }
}

