/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.datatype.rename.FileRenameConfiguration;
import org.sing_group.seda.datatype.rename.ReplaceCharacterConfiguration;
import org.sing_group.seda.datatype.rename.SequenceHeaderRenameConfiguration;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.util.StringUtils;

public class MapRenameSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private DatatypeFactory factory;
    private final SequencesGroupBuilder groupBuilder;
    private final Function<SequencesGroup[], SequencesGroupDataset> datasetBuilder;
    private FileRenameConfiguration fileRenameConfiguration;
    private SequenceHeaderRenameConfiguration headerConfiguration;
    private final Map<String, String> renamings;

    public MapRenameSequencesGroupDatasetTransformation(FileRenameConfiguration fileNameConfiguration, SequenceHeaderRenameConfiguration headerConfiguration, Map<String, String> renamings) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), fileNameConfiguration, headerConfiguration, renamings);
    }

    public MapRenameSequencesGroupDatasetTransformation(DatatypeFactory factory, FileRenameConfiguration fileNameConfiguration, SequenceHeaderRenameConfiguration headerConfiguration) {
        this(factory, fileNameConfiguration, headerConfiguration, Collections.emptyMap());
    }

    public MapRenameSequencesGroupDatasetTransformation(DatatypeFactory factory, FileRenameConfiguration fileNameConfiguration, SequenceHeaderRenameConfiguration headerConfiguration, Map<String, String> renamings) {
        this.factory = factory;
        this.datasetBuilder = factory::newSequencesGroupDataset;
        this.groupBuilder = factory::newSequencesGroup;
        this.fileRenameConfiguration = fileNameConfiguration;
        this.headerConfiguration = headerConfiguration;
        this.renamings = renamings;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        return this.datasetBuilder.apply((SequencesGroup[])dataset.getSequencesGroups().map(sequencesGroup -> this.rename((SequencesGroup)sequencesGroup)).toArray(SequencesGroup[]::new));
    }

    protected SequencesGroup rename(SequencesGroup sequencesGroup) {
        String groupName = sequencesGroup.getName();
        SequencesGroup renamedSequencesGroup = sequencesGroup;
        String newName = "";
        for (String renameKey : this.getRenamings().keySet()) {
            if (!groupName.contains(renameKey)) continue;
            String renameValue = this.getRenamings().get(renameKey);
            switch (this.fileRenameConfiguration.getMode()) {
                case NONE: {
                    newName = groupName;
                    break;
                }
                case OVERRIDE: {
                    newName = renameValue;
                    break;
                }
                case PREFIX: {
                    newName = renameValue + this.fileRenameConfiguration.getDelimiter() + groupName;
                    break;
                }
                case SUFFIX: {
                    newName = groupName + this.fileRenameConfiguration.getDelimiter() + renameValue;
                    break;
                }
                case REPLACE: {
                    newName = groupName.replace(renameKey, renameValue);
                    break;
                }
            }
            newName = MapRenameSequencesGroupDatasetTransformation.replaceCharacters(newName, this.fileRenameConfiguration.getReplaceCharacterConfiguration());
            if (this.headerConfiguration.getPosition().isPresent()) {
                String newRenameValue = MapRenameSequencesGroupDatasetTransformation.replaceCharacters(renameValue, this.fileRenameConfiguration.getReplaceCharacterConfiguration());
                AddStringHeaderRenamer headerRenamer = new AddStringHeaderRenamer(HeaderTarget.ALL, newRenameValue, this.headerConfiguration.getDelimiter(), this.headerConfiguration.getPosition().get(), this.headerConfiguration.isAddIndex(), this.headerConfiguration.getIndexDelimiter());
                renamedSequencesGroup = this.groupBuilder.of(newName, sequencesGroup.getProperties(), headerRenamer.rename(sequencesGroup, this.factory).getSequences().collect(Collectors.toList()));
            } else {
                renamedSequencesGroup = this.groupBuilder.of(newName, renamedSequencesGroup.getProperties(), renamedSequencesGroup.getSequences().collect(Collectors.toList()));
            }
            if (!this.fileRenameConfiguration.isStopAtFirstMatch()) continue;
            break;
        }
        return renamedSequencesGroup;
    }

    private static String replaceCharacters(String newName, ReplaceCharacterConfiguration configuration) {
        String toret = newName;
        if (configuration.isReplaceBlankSpaces()) {
            toret = toret.replace(" ", configuration.getReplacement());
        }
        if (configuration.isReplaceSpecialCharacters()) {
            for (String character : ReplaceCharacterConfiguration.getSpecialCharacters()) {
                toret = toret.replace(character, configuration.getReplacement());
            }
        }
        return toret;
    }

    protected Map<String, String> getRenamings() {
        return this.renamings;
    }

    public static enum RenameMode {
        PREFIX,
        SUFFIX,
        REPLACE,
        OVERRIDE,
        NONE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

