/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Function;
import org.sing_group.seda.core.filtering.DefaultSedaStringJoiner;
import org.sing_group.seda.core.filtering.EmptySedaStringJoiner;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.SedaStringJoiner;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class ConcatenateSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private static final String UNMATCHED_SEQUENCE = "Unmatched";
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final SequencesGroupBuilder groupBuilder = factory::newSequencesGroup;
    private final SequenceBuilder sequenceBuilder = factory::newSequence;
    private final String mergeName;
    private final HeaderMatcher headerMatcher;
    private final boolean mergeDescriptions;
    private final SedaStringJoiner descriptionsJoiner;

    public ConcatenateSequencesGroupDatasetTransformation(String mergeName, HeaderMatcher headerMatcher, boolean mergeDescriptions) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), mergeName, headerMatcher, mergeDescriptions);
    }

    public ConcatenateSequencesGroupDatasetTransformation(DatatypeFactory factory, String mergeName, HeaderMatcher headerMatcher, boolean mergeDescriptions) {
        this.mergeName = mergeName;
        this.headerMatcher = headerMatcher;
        this.mergeDescriptions = mergeDescriptions;
        this.descriptionsJoiner = this.mergeDescriptions ? new DefaultSedaStringJoiner() : new EmptySedaStringJoiner();
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        HashMap concatenatedSequences = new HashMap();
        dataset.getSequencesGroups().forEach(g -> g.getSequences().forEach(s -> {
            String headerMatch = this.getHeaderMatch((Sequence)s);
            if (concatenatedSequences.containsKey(headerMatch)) {
                Sequence toMerge = (Sequence)concatenatedSequences.get(headerMatch);
                String mergedDescription = this.descriptionsJoiner.merge(toMerge.getDescription(), s.getDescription());
                concatenatedSequences.put(headerMatch, this.sequenceBuilder.of(headerMatch, mergedDescription, toMerge.getChain() + s.getChain(), toMerge.getProperties()));
            } else {
                String mergedDescription = this.descriptionsJoiner.merge("", s.getDescription());
                concatenatedSequences.put(headerMatch, this.sequenceBuilder.of(headerMatch, mergedDescription, s.getChain(), s.getProperties()));
            }
        }));
        return this.builder.apply(new SequencesGroup[]{this.groupBuilder.of(this.mergeName, this.getDatasetPropertiesMap(dataset), new LinkedList<Sequence>(concatenatedSequences.values()))});
    }

    private String getHeaderMatch(Sequence s) {
        return this.headerMatcher.match(s).orElse(UNMATCHED_SEQUENCE);
    }
}

