/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.ReformatFastaConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.ReformatFastaSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class ReformatFastaSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private final ReformatFastaConfigurationPanel panel = new ReformatFastaConfigurationPanel();

    @Override
    public String getName() {
        return "Reformat file";
    }

    @Override
    public String getGroupName() {
        return ReformatFastaSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Change the format of a FASTA file (sequence fragment length, line break type, and sequence case).";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<ReformatFastaTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((ReformatFastaTransformationProvider)new JsonObjectReader().read(file, ReformatFastaTransformationProvider.class));
    }
}

