/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SequenceTranslationConfiguration {
    @XmlElement
    private Map<String, String> codonTable;
    @XmlElement
    private List<Integer> frames;
    @XmlElement
    private boolean joinFrames;
    @XmlElement
    private boolean reverseComplement;

    public SequenceTranslationConfiguration() {
    }

    public SequenceTranslationConfiguration(Map<String, String> codonTable, boolean reverseComplement, int ... frames) {
        this(codonTable, reverseComplement, false, frames);
    }

    public SequenceTranslationConfiguration(Map<String, String> codonTable, boolean reverseComplement, boolean joinFrames, int ... frames) {
        this.codonTable = codonTable;
        this.frames = Arrays.stream(frames).boxed().collect(Collectors.toList());
        this.joinFrames = joinFrames;
        this.reverseComplement = reverseComplement;
    }

    public List<Integer> getFrames() {
        return this.frames;
    }

    public Map<String, String> getCodonTable() {
        return this.codonTable;
    }

    public boolean isJoinFrames() {
        return this.joinFrames;
    }

    public boolean isReverseComplement() {
        return this.reverseComplement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codonTable == null ? 0 : this.codonTable.hashCode());
        result = 31 * result + (this.frames == null ? 0 : this.frames.hashCode());
        result = 31 * result + (this.joinFrames ? 1231 : 1237);
        result = 31 * result + (this.reverseComplement ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceTranslationConfiguration other = (SequenceTranslationConfiguration)obj;
        if (this.codonTable == null ? other.codonTable != null : !this.codonTable.equals(other.codonTable)) {
            return false;
        }
        if (this.frames == null ? other.frames != null : !this.frames.equals(other.frames)) {
            return false;
        }
        if (this.joinFrames != other.joinFrames) {
            return false;
        }
        return this.reverseComplement == other.reverseComplement;
    }
}

