/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.cli.command.RenameHeaderCommand;
import org.sing_group.seda.core.rename.FieldSplitRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderMultipartSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.rename.RenameHeaderTransformationProvider;

public class RenameHeaderMultipartCommand
extends RenameHeaderCommand {
    public static final StringOption OPTION_FIELD_DELIMITER = new StringOption("field-delimiter", "fd", "The field delimiter.", true, true);
    public static final DefaultValuedStringOption OPTION_JOIN_DELIMITER = new DefaultValuedStringOption("join-delimiter", "jd", "The join delimiter.", "_");
    public static final DefaultValuedStringOption OPTION_FIELD_MODE = new DefaultValuedStringOption("field-mode", "fm", RenameHeaderMultipartSedaPluginInfo.PARAM_FIELD_MODE_HELP, FieldSplitRenamer.Mode.KEEP.name().toLowerCase());
    public static final StringOption OPTION_FIELDS = new StringOption("fields", "f", "The comma-separated list of fields starting at 1. Note that when the keep mode is used, then the order of the fields is preserved in the output, meaning that it is possible to swap fields.", true, true);

    public String getName() {
        return "rename-header-multipart";
    }

    public String getDescriptiveName() {
        return "Rename header (Multipart)";
    }

    public String getDescription() {
        return "Modify sequence headers by keeping or removing fields.";
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.addAll(super.createSedaOptions());
        options.add((Option<?>)OPTION_FIELD_DELIMITER);
        options.add((Option<?>)OPTION_JOIN_DELIMITER);
        options.add((Option<?>)OPTION_FIELD_MODE);
        options.add((Option<?>)OPTION_FIELDS);
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RenameHeaderTransformationProvider provider = new RenameHeaderTransformationProvider();
        RenameHeaderMultipartCommand.checkMandatoryOption(parameters, OPTION_FIELD_DELIMITER);
        RenameHeaderMultipartCommand.checkMandatoryOption(parameters, OPTION_FIELDS);
        String fieldDelimiter = (String)parameters.getSingleValue((Option)OPTION_FIELD_DELIMITER);
        String joinDelimiter = (String)parameters.getSingleValue((Option)OPTION_JOIN_DELIMITER);
        FieldSplitRenamer.Mode mode = null;
        try {
            mode = FieldSplitRenamer.Mode.valueOf(((String)parameters.getSingleValue((Option)OPTION_FIELD_MODE)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            RenameHeaderMultipartCommand.invalidEnumValue(OPTION_FIELD_MODE);
        }
        List<Integer> fields = null;
        try {
            fields = Arrays.stream(((String)parameters.getSingleValue((Option)OPTION_FIELDS)).split(",")).map(String::trim).map(Integer::parseInt).map(f -> f - 1).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            RenameHeaderMultipartCommand.formattedValidationError("Invalid format for " + RenameHeaderMultipartCommand.formatParam(OPTION_FIELDS));
        }
        HeaderTarget headerTarget = this.getHeaderTarget(parameters);
        provider.setHeaderRenamer(new FieldSplitRenamer(headerTarget, fieldDelimiter, joinDelimiter, mode, fields));
        return provider;
    }
}

