/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.BigDecimalDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.bio.SequenceType;
import org.sing_group.seda.bio.consensus.ConsensusBaseStrategy;
import org.sing_group.seda.cli.command.ReformatFastaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.GenerateConsensusSequenceSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.consensus.GenerateConsensusSequenceTransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class GenerateConsensusSequenceCommand
extends ReformatFastaCommand {
    public static final DefaultValuedStringOption OPTION_SEQUENCE_TYPE = new DefaultValuedStringOption("sequence-type", "st", GenerateConsensusSequenceSedaPluginInfo.PARAM_SEQUENCE_TYPE_HELP, SequenceType.NUCLEOTIDE.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_CONSENSUS_BASE = new DefaultValuedStringOption("consensus-bases", "cb", GenerateConsensusSequenceSedaPluginInfo.PARAM_CONSENSUS_BASE_HELP, ConsensusBaseStrategy.MOST_FREQUENT.name().toLowerCase());
    public static final BigDecimalDefaultValuedStringConstructedOption OPTION_MINIMUM_PRESENCE = new BigDecimalDefaultValuedStringConstructedOption("minimum-presence", "mp", "The minimum presence for a given nucleotide or amino acid in order to be part of the consensus sequence. Read the consensus bases description to understand how this option is used in each case.", BigDecimal.valueOf(0.5));
    public static final FlagOption OPTION_VERBOSE = new FlagOption("verbose", "v", "In protein sequences, when this option is unselected then X is used for ambiguous positions in the consensus sequence. On the other hand, when this option is selected, then all amino acids in such positions are reported (for instance [HWY]).");

    @Override
    public String getName() {
        return "consensus";
    }

    @Override
    public String getDescriptiveName() {
        return "Consensus sequence";
    }

    @Override
    public String getDescription() {
        return "Create a consensus sequence using the set of aligned sequences present in the selected FASTA file(s).";
    }

    @Override
    protected String getSedaGroup() {
        return GenerateConsensusSequenceSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.add((Option<?>)OPTION_SEQUENCE_TYPE);
        options.add((Option<?>)OPTION_CONSENSUS_BASE);
        options.add((Option<?>)OPTION_MINIMUM_PRESENCE);
        options.add((Option<?>)OPTION_VERBOSE);
        options.addAll(super.createSedaOptions());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        GenerateConsensusSequenceTransformationProvider provider = new GenerateConsensusSequenceTransformationProvider();
        SequenceType sequenceType = null;
        ConsensusBaseStrategy consensusBaseStrategy = null;
        try {
            sequenceType = SequenceType.valueOf(parameters.getSingleValueString((Option)OPTION_SEQUENCE_TYPE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            GenerateConsensusSequenceCommand.invalidEnumValue(OPTION_SEQUENCE_TYPE);
        }
        try {
            consensusBaseStrategy = ConsensusBaseStrategy.valueOf(parameters.getSingleValueString((Option)OPTION_CONSENSUS_BASE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            GenerateConsensusSequenceCommand.invalidEnumValue(OPTION_CONSENSUS_BASE);
        }
        if (parameters.hasFlag((Option)OPTION_VERBOSE) && sequenceType == SequenceType.NUCLEOTIDE) {
            GenerateConsensusSequenceCommand.formattedValidationError("The verbose option is only available for protein sequence type.");
        }
        provider.setSequenceType(sequenceType);
        provider.setConsensusBaseStrategy(consensusBaseStrategy);
        provider.setMinimumPresence(((BigDecimal)parameters.getSingleValue((Option)OPTION_MINIMUM_PRESENCE)).doubleValue());
        provider.setVerbose(parameters.hasFlag((Option)OPTION_VERBOSE));
        provider.setReformatFastaTransformationProvider((ReformatFastaTransformationProvider)super.getTransformation(parameters));
        return provider;
    }

    @Override
    protected GenerateConsensusSequenceTransformationProvider getTransformation(File parametersFile) throws IOException {
        return (GenerateConsensusSequenceTransformationProvider)new JsonObjectReader().read(parametersFile, GenerateConsensusSequenceTransformationProvider.class);
    }
}

