/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities.quantification;

import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationDataset;
import es.uvigo.ei.sing.s2p.core.entities.quantification.QuantificationSample;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class QuantificationCondition {
    private String name;
    private List<QuantificationSample> samples;

    public QuantificationCondition(String name, List<QuantificationSample> samples) {
        this.name = name;
        this.samples = samples;
    }

    public String getName() {
        return this.name;
    }

    public List<QuantificationSample> getSamples() {
        return this.samples;
    }

    public Set<String> getProteins() {
        return QuantificationDataset.getProteins(this.samples.stream());
    }

    public int hashCode() {
        return Objects.hash(this.samples);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object aThat) {
        if (aThat == null) {
            return false;
        }
        if (!(aThat instanceof QuantificationCondition)) {
            return false;
        }
        QuantificationCondition that = (QuantificationCondition)aThat;
        return this.name.equals(that.name) && this.samples.equals(that.samples);
    }
}

