/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.workbench.Workbench;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class OperationWrapper
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(OperationWrapper.class);
    public static final String SUSPENSION_POINTS = "mainwindow.menubar.names_append_suspension_points";
    public static final boolean DEFAULT_SUSPENSION_POINTS = true;
    private OperationDefinition<?> operation;

    public OperationWrapper(OperationDefinition<?> op) {
        this.operation = op;
        this.putValue("Name", this.getOperationName());
        this.setEnabled(op.isEnabled());
    }

    private String getOperationName() {
        return this.operation.getMenuName() + this.getSuspensionPoints();
    }

    private String getSuspensionPoints() {
        return this.isAddSuspensionPoints() ? "..." : "";
    }

    private boolean isAddSuspensionPoints() {
        String suspensionPoints = Workbench.CONFIG.getProperty(SUSPENSION_POINTS);
        if (suspensionPoints != null) {
            if (suspensionPoints.toLowerCase().equals("false")) {
                return false;
            }
            if (suspensionPoints.toLowerCase().equals("true")) {
                return true;
            }
            LOGGER.warn((Object)"Warning: invalid value for mainwindow.menubar.names_append_suspension_points. Using default value instead.");
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Workbench.getInstance().executeOperation(this.operation);
    }

    public OperationDefinition<?> getOperationDefinition() {
        return this.operation;
    }

    public void updateState() {
    }

    public String toString() {
        return this.operation.getName() + " @ " + this.operation.getPath();
    }
}

