/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.heatmap;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import java.util.stream.Collectors;

public class SpotRenderer {
    private IdentificationsMode mode;
    private boolean showSpot;

    public SpotRenderer(IdentificationsMode mode, boolean showSpot) {
        this.mode = mode;
        this.showSpot = showSpot;
    }

    public String getSpotValue(String spot, MascotIdentifications spotIdentifications) {
        StringBuilder sb = new StringBuilder();
        if (this.mode.equals((Object)IdentificationsMode.BEST_SCORE)) {
            if (spotIdentifications.isEmpty()) {
                sb.append("N/A");
            } else {
                sb.append(((MascotEntry)spotIdentifications.getFirst()).getTitle());
            }
        } else if (this.mode.equals((Object)IdentificationsMode.ALL)) {
            if (spotIdentifications.isEmpty()) {
                sb.append("N/A");
            } else {
                sb.append(spotIdentifications.stream().map(MascotEntry::getTitle).distinct().collect(Collectors.joining(", ")).toString());
            }
        }
        if (this.showSpot) {
            boolean onlySpot = this.mode.equals((Object)IdentificationsMode.NONE);
            sb.append(onlySpot ? "" : " (").append(spot).append(onlySpot ? "" : ")");
        }
        return sb.toString();
    }

    public static enum IdentificationsMode {
        BEST_SCORE("Best Mascot score"),
        ALL("All identifications"),
        NONE("None");

        private String description;

        private IdentificationsMode(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

