/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.samespots;

import es.uvigo.ei.sing.s2p.core.io.samespots.SameSpotsReportFileWriterConfiguration;
import es.uvigo.ei.sing.s2p.gui.components.dialog.AbstractFileInputJDialog;
import es.uvigo.ei.sing.s2p.gui.samespots.SameSpotsReportFileWriterConfigurationPanel;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;

public class FillSameSpotsReportDialog
extends AbstractFileInputJDialog {
    private static final long serialVersionUID = 1L;
    private InputParametersPanel inputParametersPanel;
    private InputParameter[] parameters;
    private SameSpotsReportFileWriterConfigurationPanel configurationPanel;
    private JFileChooserPanel fileChooserPanel;

    public FillSameSpotsReportDialog(Window parent) {
        super(parent);
    }

    protected String getDialogTitle() {
        return "Fill SameSpots report";
    }

    protected String getDescription() {
        return "This operation allows you to fill a SameSpots report using a set of loaded Mascot identifications.";
    }

    protected JPanel getInputComponentsPane() {
        this.inputParametersPanel = new InputParametersPanel(this.getParameters());
        return this.inputParametersPanel;
    }

    private InputParameter[] getParameters() {
        this.parameters = new InputParameter[2];
        this.parameters[0] = this.createDirectorySelectionParameter();
        this.parameters[1] = this.createConfigurationParameter();
        return this.parameters;
    }

    private InputParameter createDirectorySelectionParameter() {
        this.fileChooserPanel = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withFileChooser(this.getFileChooser()).withLabel("").build();
        this.fileChooserPanel.addFileChooserListener(this::onFileChoosed);
        return new InputParameter("SameSports report directory", (JComponent)this.fileChooserPanel, "The directory containing the SameSpots HTM reports.");
    }

    private void onFileChoosed(ChangeEvent event) {
        this.checkOkButton();
    }

    private InputParameter createConfigurationParameter() {
        this.configurationPanel = new SameSpotsReportFileWriterConfigurationPanel();
        this.configurationPanel.addPropertyChangeListener("property.report.configuration", this::reportConfigurationChanged);
        return new InputParameter("Configuration", (JComponent)this.configurationPanel, "Different options to configure the way that the report is processed.");
    }

    private void reportConfigurationChanged(PropertyChangeEvent e) {
        this.checkOkButton();
    }

    private void checkOkButton() {
        this.okButton.setEnabled(this.isValidUserInput());
    }

    public boolean isValidUserInput() {
        return this.configurationPanel.isValidConfiguration() && this.isSelectedFileValid();
    }

    private boolean isSelectedFileValid() {
        return this.fileChooserPanel.getSelectedFile() != null && !this.fileChooserPanel.getSelectedFile().equals("");
    }

    public SameSpotsReportFileWriterConfiguration getSelectedConfiguration() {
        return this.configurationPanel.getSelectedConfiguration();
    }

    public File getSelectedFile() {
        return this.fileChooserPanel.getSelectedFile();
    }

    public void setVisible(boolean b) {
        this.pack();
        super.setVisible(b);
    }
}

