/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import weka.core.FastVector;
import weka.core.RevisionUtils;
import weka.experiment.DatabaseUtils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class DatabaseResultListener
extends DatabaseUtils
implements ResultListener {
    static final long serialVersionUID = 7388014746954652818L;
    protected ResultProducer m_ResultProducer;
    protected String m_ResultsTableName;
    protected boolean m_Debug = true;
    protected String m_CacheKeyName = "";
    protected int m_CacheKeyIndex;
    protected Object[] m_CacheKey;
    protected FastVector m_Cache = new FastVector();

    public String globalInfo() {
        return "Takes results from a result producer and sends them to a database.";
    }

    public void preProcess(ResultProducer rp) throws Exception {
        this.m_ResultProducer = rp;
        this.updateResultsTableName(this.m_ResultProducer);
    }

    public void postProcess(ResultProducer rp) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer calling postProcess!!");
        }
        this.disconnectFromDatabase();
    }

    public String[] determineColumnConstraints(ResultProducer rp) throws Exception {
        FastVector cNames = new FastVector();
        this.updateResultsTableName(rp);
        DatabaseMetaData dbmd = this.m_Connection.getMetaData();
        ResultSet rs = this.m_checkForUpperCaseNames ? dbmd.getColumns(null, null, this.m_ResultsTableName.toUpperCase(), null) : dbmd.getColumns(null, null, this.m_ResultsTableName, null);
        boolean tableExists = false;
        int numColumns = 0;
        while (rs.next()) {
            tableExists = true;
            String name = rs.getString(4);
            if (!name.toLowerCase().startsWith("measure")) continue;
            ++numColumns;
            cNames.addElement(name);
        }
        if (!tableExists) {
            return null;
        }
        String[] columnNames = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnNames[i] = (String)cNames.elementAt(i);
        }
        return columnNames;
    }

    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer calling acceptResult!!");
        }
        if (result != null) {
            this.putResultInTable(this.m_ResultsTableName, rp, key, result);
        }
    }

    public boolean isResultRequired(ResultProducer rp, Object[] key) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer calling isResultRequired!");
        }
        if (this.m_Debug) {
            System.err.print("Is result required...");
            for (int i = 0; i < key.length; ++i) {
                System.err.print(" " + key[i]);
            }
            System.err.flush();
        }
        boolean retval = false;
        if (!this.m_CacheKeyName.equals("")) {
            if (!this.isCacheValid(key)) {
                this.loadCache(rp, key);
            }
            retval = !this.isKeyInCache(rp, key);
        } else {
            boolean bl = retval = !this.isKeyInTable(this.m_ResultsTableName, rp, key);
        }
        if (this.m_Debug) {
            System.err.println(" ..." + (retval ? "required" : "not required") + (this.m_CacheKeyName.equals("") ? "" : " (cache)"));
            System.err.flush();
        }
        return retval;
    }

    protected void updateResultsTableName(ResultProducer rp) throws Exception {
        String tableName;
        if (!this.isConnected()) {
            this.connectToDatabase();
        }
        if (!this.experimentIndexExists()) {
            this.createExperimentIndex();
        }
        if ((tableName = this.getResultsTableName(rp)) == null) {
            tableName = this.createExperimentIndexEntry(rp);
        }
        if (!this.tableExists(tableName)) {
            this.createResultsTable(rp, tableName);
        }
        this.m_ResultsTableName = tableName;
    }

    public String cacheKeyNameTipText() {
        return "Set the name of the key field by which to cache.";
    }

    public String getCacheKeyName() {
        return this.m_CacheKeyName;
    }

    public void setCacheKeyName(String newCacheKeyName) {
        this.m_CacheKeyName = newCacheKeyName;
    }

    protected boolean isCacheValid(Object[] key) {
        if (this.m_CacheKey == null) {
            return false;
        }
        if (this.m_CacheKey.length != key.length) {
            return false;
        }
        for (int i = 0; i < key.length; ++i) {
            if (i == this.m_CacheKeyIndex || this.m_CacheKey[i].equals(key[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isKeyInCache(ResultProducer rp, Object[] key) throws Exception {
        for (int i = 0; i < this.m_Cache.size(); ++i) {
            if (!this.m_Cache.elementAt(i).equals(key[this.m_CacheKeyIndex])) continue;
            return true;
        }
        return false;
    }

    protected void loadCache(ResultProducer rp, Object[] key) throws Exception {
        System.err.print(" (updating cache)");
        System.err.flush();
        this.m_Cache.removeAllElements();
        this.m_CacheKey = null;
        String query = "SELECT Key_" + this.m_CacheKeyName + " FROM " + this.m_ResultsTableName;
        String[] keyNames = rp.getKeyNames();
        if (keyNames.length != key.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        this.m_CacheKeyIndex = -1;
        for (int i = 0; i < keyNames.length; ++i) {
            if (!keyNames[i].equalsIgnoreCase(this.m_CacheKeyName)) continue;
            this.m_CacheKeyIndex = i;
            break;
        }
        if (this.m_CacheKeyIndex == -1) {
            throw new Exception("No key field named " + this.m_CacheKeyName + " (as specified for caching)");
        }
        boolean first = true;
        for (int i = 0; i < key.length; ++i) {
            if (key[i] == null || i == this.m_CacheKeyIndex) continue;
            if (first) {
                query = query + " WHERE ";
                first = false;
            } else {
                query = query + " AND ";
            }
            query = query + "Key_" + keyNames[i] + '=';
            query = key[i] instanceof String ? query + "'" + DatabaseUtils.processKeyString(key[i].toString()) + "'" : query + key[i].toString();
        }
        ResultSet rs = this.select(query);
        while (rs.next()) {
            String keyVal = rs.getString(1);
            if (rs.wasNull()) continue;
            this.m_Cache.addElement(keyVal);
        }
        this.close(rs);
        this.m_CacheKey = (Object[])key.clone();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5125 $");
    }
}

