/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table;

import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;

public class ExtendedJXTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    private CustomColumnControlButton columnControlButton;
    private boolean showVisibilityActions = true;

    public ExtendedJXTable() {
        this.init();
    }

    public ExtendedJXTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public ExtendedJXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public ExtendedJXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public ExtendedJXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public ExtendedJXTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public ExtendedJXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    private void init() {
        this.columnControlButton = new CustomColumnControlButton(this);
        this.setColumnControl((JComponent)((Object)this.columnControlButton));
    }

    public void addAction(Action a) {
        this.getActionMap().put(this.getActionName(a), a);
        this.columnControlButton.update();
    }

    private String getActionName(Action a) {
        return "column." + a.getValue("Name");
    }

    public void setColumVisibilityActionsEnabled(boolean enabled) {
        this.showVisibilityActions = enabled;
        this.columnControlButton.update();
    }

    public List<String> getColumnNames() {
        return IntStream.range(0, this.getModel().getColumnCount()).boxed().map(this.getModel()::getColumnName).collect(Collectors.toList());
    }

    public Object[][] getData() {
        TableModel model = this.getModel();
        Object[][] data = new Object[model.getRowCount()][model.getColumnCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                Object value = model.getValueAt(i, j);
                data[i][j] = value == null ? "" : value;
            }
        }
        return data;
    }

    private class CustomColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = 1L;

        public CustomColumnControlButton(JXTable table) {
            super(table);
        }

        protected void createVisibilityActions() {
            if (ExtendedJXTable.this.showVisibilityActions) {
                super.createVisibilityActions();
            }
        }

        public void update() {
            super.populatePopup();
        }
    }
}

