/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.heatmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.sing_group.gc4s.input.DoubleRange;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.ui.text.VerticalLabelUI;
import org.sing_group.gc4s.utilities.Gradient;
import org.sing_group.gc4s.utilities.ImageIOUtils;
import org.sing_group.gc4s.utilities.MatrixUtils;
import org.sing_group.gc4s.visualization.ColorKeyLegend;
import org.sing_group.gc4s.visualization.heatmap.JHeatMapModel;

public class JHeatMap
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double DEFAULT_ZOOM_SCALE = 1.25;
    private static final int DEFAULT_SIZE = 65;
    private static final Color DEFAULT_NAN_COLOR = Color.LIGHT_GRAY;
    private static final Color DEFAULT_LOW_COLOR = Color.GREEN;
    private static final Color DEFAULT_HIGH_COLOR = Color.RED;
    private static final int DEFAULT_STEPS = 100;
    private static final boolean DEFAULT_MOUSE_ZOOM_ENABLED = true;
    private int cellSize = 65;
    private Color lowColor = DEFAULT_LOW_COLOR;
    private Color highColor = DEFAULT_HIGH_COLOR;
    private Color nanColor = DEFAULT_NAN_COLOR;
    private DecimalFormat decimalFormat = new DecimalFormat();
    private Optional<Font> font = Optional.empty();
    private double[][] data;
    private String[] columnNames;
    private String[] rowNames;
    private Optional<List<String>> visibleRows = Optional.empty();
    private Optional<List<String>> visibleColumns = Optional.empty();
    private ColorKeyLegend colorKey;
    private JXTable heatmap;
    private HeatMapTableModel heatmapTM;
    private Function<Double, Color> doubleToColor;
    private double lowValue = Double.NaN;
    private double highValue = Double.NaN;
    private boolean mouseZoomEnabled = true;

    public JHeatMap(JHeatMapModel model) {
        this(model.getData(), model.getRowNames(), model.getColumnNames());
    }

    public JHeatMap(double[][] data, String[] rowNames, String[] columnNames) {
        this.data = data;
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.initComponent();
    }

    private void initComponent() {
        this.initializeColors();
        this.setLayout(new BorderLayout());
        this.add(this.getColorKey(), "North");
        this.add(this.getHeatMap(), "Center");
    }

    private void initializeColors() {
        final double min = this.getLowValue();
        final double max = this.getHighValue();
        final Color[] colorGradient = this.getColorGradient();
        this.doubleToColor = new Function<Double, Color>(){

            @Override
            public Color apply(Double t) {
                if (Double.isNaN(t)) {
                    return JHeatMap.this.nanColor;
                }
                double normalized = this.normalize(this.checkRange(t), max, min);
                int colorIndex = (int)(normalized * 99.0);
                return colorGradient[colorIndex];
            }

            private double checkRange(Double t) {
                if (t > max) {
                    return max;
                }
                if (t < min) {
                    return min;
                }
                return t;
            }

            private double normalize(double d, double max2, double min2) {
                return (d - min2) / (max2 - min2);
            }
        };
        this.updateUI();
    }

    private Color[] getColorGradient() {
        return Gradient.createGradient((Color)this.lowColor, (Color)this.highColor, (int)100);
    }

    private Component getColorKey() {
        this.colorKey = new ColorKeyLegend(this.lowColor, this.highColor, MatrixUtils.min((double[][])this.data), MatrixUtils.max((double[][])this.data));
        return new CenteredJPanel((Component)this.colorKey);
    }

    private Component getHeatMap() {
        this.heatmapTM = new HeatMapTableModel();
        this.heatmap = new JXTable((TableModel)this.heatmapTM);
        this.heatmap.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomTableCellRenderer());
        this.heatmap.setTableHeader(null);
        this.heatmap.addMouseWheelListener(e -> {
            if (!this.mouseZoomEnabled) {
                return;
            }
            if (e.getWheelRotation() < 0) {
                this.zoomIn();
            } else {
                this.zoomOut();
            }
        });
        this.heatmap.setFont(this.heatmap.getFont().deriveFont((float)this.cellSize));
        this.heatmap.setColumnControlVisible(false);
        this.heatmap.setShowHorizontalLines(false);
        this.heatmap.setShowVerticalLines(false);
        this.heatmap.setFillsViewportHeight(false);
        this.heatmap.setRowMargin(0);
        this.heatmap.setIntercellSpacing(new Dimension(0, 0));
        this.heatmap.setCellSelectionEnabled(false);
        this.heatmap.setAutoCreateRowSorter(false);
        this.heatmap.setAutoResizeMode(0);
        this.fixCellSize();
        return new JScrollPane((Component)this.heatmap);
    }

    private void fixCellSize() {
        this.heatmap.setRowHeight(0, this.getMaxColumnNameLength());
        IntStream.range(1, this.getVisibleRowNames().size() + 1).forEach(row -> this.heatmap.setRowHeight(row, this.cellSize));
        for (int i = 0; i < this.heatmap.getColumnModel().getColumnCount(); ++i) {
            TableColumn c = this.heatmap.getColumnModel().getColumn(i);
            c.setMinWidth(this.cellSize);
            c.setMaxWidth(this.cellSize);
            c.setPreferredWidth(this.cellSize);
        }
        int maxRowWidth = this.getMaxRowNameLength();
        TableColumn rowNamesColumn = this.heatmap.getColumnModel().getColumn(0);
        rowNamesColumn.setMinWidth(maxRowWidth);
        rowNamesColumn.setMaxWidth(maxRowWidth);
        rowNamesColumn.setPreferredWidth(maxRowWidth);
    }

    private int getMaxRowNameLength() {
        return Stream.of(this.rowNames).mapToInt(this::requiredLength).max().getAsInt();
    }

    private int getMaxColumnNameLength() {
        return Stream.of(this.columnNames).mapToInt(this::requiredLength).max().getAsInt();
    }

    private int requiredLength(String s) {
        Font heatmapFont = this.font.orElse(new JLabel().getFont());
        return new JLabel().getFontMetrics(heatmapFont).stringWidth(s) + 10;
    }

    public void zoomIn(double scale) {
        this.scaleCellSize(scale);
    }

    private void zoomIn() {
        this.zoomIn(1.25);
    }

    public void zoomOut(double scale) {
        this.scaleCellSize(scale);
    }

    private void zoomOut() {
        this.zoomOut(0.8);
    }

    private void scaleCellSize(double scale) {
        this.cellSize = (int)((double)this.cellSize * scale);
        this.fixCellSize();
    }

    public void toPngImage(File f) throws IOException {
        ImageIOUtils.toImage((String)"png", (File)f, (Component[])new Component[]{this.colorKey, this.heatmap});
    }

    public void setLowColor(Color color) {
        this.lowColor = color;
        this.colorKey.setLowColor(color);
        this.initializeColors();
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public void setHighColor(Color color) {
        this.highColor = color;
        this.colorKey.setHighColor(color);
        this.initializeColors();
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public void setColors(Color lowColor, Color highColor) {
        this.lowColor = lowColor;
        this.colorKey.setLowColor(lowColor);
        this.setHighColor(highColor);
    }

    public void setNanColor(Color color) {
        this.nanColor = color;
        this.updateUI();
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        this.colorKey.setDecimalFormat(decimalFormat);
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
        this.colorKey.setLowValue(MatrixUtils.min((double[][])data));
        this.colorKey.setHighValue(MatrixUtils.max((double[][])data));
        this.initializeColors();
        SwingUtilities.invokeLater(() -> {
            this.heatmapTM.fireTableDataChanged();
            this.fixCellSize();
        });
    }

    public void setHeatmapFont(Font font) {
        this.font = Optional.ofNullable(font);
        this.colorKey.setFont(font);
        this.fixCellSize();
        this.updateUI();
    }

    public Font getHeatmapFont() {
        return this.font.orElse(super.getFont());
    }

    public double getLowValue() {
        if (Double.isNaN(this.lowValue)) {
            return MatrixUtils.min((double[][])this.data);
        }
        return this.lowValue;
    }

    public double getHighValue() {
        if (Double.isNaN(this.highValue)) {
            return MatrixUtils.max((double[][])this.data);
        }
        return this.highValue;
    }

    public void setValuesRange(DoubleRange range) {
        this.lowValue = range.getMin();
        this.highValue = range.getMax();
        this.colorKey.setLowValue(this.lowValue);
        this.colorKey.setHighValue(this.highValue);
        this.initializeColors();
    }

    public List<String> getRowNames() {
        return new LinkedList<String>(Arrays.asList(this.rowNames));
    }

    public List<String> getColumnNames() {
        return new LinkedList<String>(Arrays.asList(this.columnNames));
    }

    public List<String> getVisibleRowNames() {
        if (this.visibleRows.isPresent()) {
            return this.visibleRows.get();
        }
        return this.getRowNames();
    }

    public List<String> getVisibleColumnNames() {
        if (this.visibleColumns.isPresent()) {
            return this.visibleColumns.get();
        }
        return this.getColumnNames();
    }

    public void setVisibleRowNames(List<String> rowNames) {
        this.visibleRows = rowNames != null && !rowNames.isEmpty() ? Optional.of(rowNames) : Optional.empty();
        this.updateVisibleRows();
    }

    private void updateVisibleRows() {
        this.updateRowFilter();
    }

    public void setVisibleColumnNames(List<String> columnNames) {
        this.visibleColumns = columnNames != null && !columnNames.isEmpty() ? Optional.of(columnNames) : Optional.empty();
        this.updateVisibleColumns();
    }

    public void setMouseZoomEnabled(boolean enabled) {
        this.mouseZoomEnabled = enabled;
    }

    private void updateVisibleColumns() {
        List<String> visibleColumnNames = this.getVisibleColumnNames();
        List<String> columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.size(); ++i) {
            String colName = columnNames.get(i);
            boolean visible = visibleColumnNames.contains(colName);
            this.getTableColumnExt(i + 1).setVisible(visible);
        }
    }

    private TableColumnExt getTableColumnExt(int modelIndex) {
        return (TableColumnExt)this.heatmap.getColumns(true).get(modelIndex);
    }

    private void updateRowFilter() {
        this.heatmap.setRowFilter(this.getRowFilter());
    }

    private TestRowFilter<Object, Object> getRowFilter() {
        return new TestRowFilter<Object, Object>();
    }

    private class TestRowFilter<M, I>
    extends RowFilter<M, I> {
        private TestRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends M, ? extends I> entry) {
            if (entry.getIdentifier().equals(0)) {
                return true;
            }
            return JHeatMap.this.getVisibleRowNames().contains(entry.getStringValue(0));
        }
    }

    private final class CustomTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public CustomTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof CellValue) {
                double cellValue = ((CellValue)value).getValue();
                this.setBackground((Color)JHeatMap.this.doubleToColor.apply(cellValue));
                this.setText("");
                this.setToolTipText(this.format(cellValue));
            } else {
                this.setText(value.toString());
                this.setBackground(Color.WHITE);
                this.setHorizontalAlignment(0);
                this.setToolTipText("");
            }
            if (table.convertRowIndexToModel(row) == 0) {
                this.setUI((LabelUI)new VerticalLabelUI(false));
                this.setHorizontalAlignment(2);
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                this.setFont(JHeatMap.this.getHeatmapFont());
            } else {
                this.setUI(new BasicLabelUI());
                this.setHorizontalAlignment(4);
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                this.setFont(JHeatMap.this.getHeatmapFont());
            }
            return this;
        }

        private String format(double cellValue) {
            return Double.isNaN(cellValue) ? "N/A" : JHeatMap.this.decimalFormat.format(cellValue);
        }
    }

    private final class CellValue {
        private double value;

        public CellValue(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return Double.toString(this.value);
        }
    }

    class HeatMapTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        HeatMapTableModel() {
        }

        @Override
        public int getRowCount() {
            return JHeatMap.this.rowNames.length + 1;
        }

        @Override
        public int getColumnCount() {
            return JHeatMap.this.columnNames.length + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == 0 && columnIndex == 0) {
                return "";
            }
            if (rowIndex == 0) {
                return JHeatMap.this.columnNames[columnIndex - 1];
            }
            if (columnIndex == 0) {
                return JHeatMap.this.rowNames[rowIndex - 1];
            }
            return new CellValue(JHeatMap.this.data[rowIndex - 1][columnIndex - 1]);
        }
    }
}

