/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.samples;

import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.entities.SpotMascotIdentifications;
import es.uvigo.ei.sing.s2p.core.io.SpotsDataWriter;
import es.uvigo.ei.sing.s2p.gui.components.dialog.ExportCsvDialog;
import es.uvigo.ei.sing.s2p.gui.samples.SamplesComparisonTableModel;
import es.uvigo.ei.sing.s2p.gui.spots.SpotUtils;
import es.uvigo.ei.sing.s2p.gui.spots.heatmap.HeatMapModelBuilder;
import es.uvigo.ei.sing.s2p.gui.spots.heatmap.SpotRenderer;
import es.uvigo.ei.sing.s2p.gui.table.ExtendedCsvTable;
import es.uvigo.ei.sing.s2p.gui.table.TestRowFilter;
import es.uvigo.ei.sing.s2p.gui.table.spots.SpotPresenceTester;
import es.uvigo.ei.sing.s2p.gui.table.spots.SpotsCsvTable;
import es.uvigo.ei.sing.s2p.gui.util.CsvUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.sing_group.gc4s.event.PopupMenuAdapter;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.visualization.heatmap.JHeatMapModel;

public class SamplesComparisonTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ExtendedCsvTable table;
    private SamplesComparisonTableModel tableModel;
    private List<Sample> samples;
    private Map<Sample, Color> sampleColors;
    private Map<Sample, String> sampleLabels;
    private SpotPresenceTester spotPresenceTester;
    private boolean allowSpotEdition = false;
    private boolean showProteinIdentifications = false;
    private Optional<SpotMascotIdentifications> mascotIdentifications = Optional.empty();
    private ExtendedAbstractAction removeSpotsAction;
    private AbstractAction exportToCsvWithIdentificationsAction;

    public SamplesComparisonTable(List<Sample> samples) {
        this(samples, false);
    }

    public SamplesComparisonTable(List<Sample> samples, boolean allowSpotEdition) {
        this(samples, new HashMap<Sample, Color>(), new HashMap<Sample, String>(), allowSpotEdition);
    }

    public SamplesComparisonTable(List<Sample> samples, Map<Sample, Color> sampleColors, Map<Sample, String> sampleLabels) {
        this(samples, sampleColors, sampleLabels, false);
    }

    public SamplesComparisonTable(List<Sample> samples, Map<Sample, Color> sampleColors, Map<Sample, String> sampleLabels, boolean allowSpotEdition) {
        this.samples = samples;
        this.sampleColors = sampleColors;
        this.sampleLabels = sampleLabels;
        this.allowSpotEdition = allowSpotEdition;
        this.initComponent();
    }

    private void initComponent() {
        this.initTable();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
    }

    private void initTable() {
        this.tableModel = new SamplesComparisonTableModel(this.samples, this.allowSpotEdition);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SamplesComparisonTable.this.updateSpotPresenceTester();
            }
        });
        this.table = new SpotsCsvTable((TableModel)this.tableModel, this::getSpotValue);
        this.table.setEditable(true);
        SamplesComparisonTableCellRenderer renderer = new SamplesComparisonTableCellRenderer();
        this.table.setDefaultRenderer(Double.class, (TableCellRenderer)((Object)renderer));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)renderer));
        this.table.getTableHeader().setDefaultRenderer(new SamplesComparisonTableHeaderCellRenderer(this.table.getTableHeader().getDefaultRenderer()));
        this.table.setColumnControlVisible(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addExportToCsvAction();
        this.table.addAction(this.getExportToCsvWithIdentificationsAction());
        this.updateSpotPresenceTester();
    }

    public void addColumnModelListener(TableColumnModelListener listener) {
        this.table.getColumnModel().addColumnModelListener(listener);
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    private void updateSpotPresenceTester() {
        this.spotPresenceTester = new SpotPresenceTester(SamplesComparisonTable.getProteins(this.samples));
        this.table.setRowFilter(new TestRowFilter(this.spotPresenceTester, 0));
    }

    private String getSpotValue(String spot) {
        return SpotUtils.spotValue(spot, this.showProteinIdentifications, this.mascotIdentifications);
    }

    private static Set<String> getProteins(List<Sample> samples) {
        HashSet<String> all = new HashSet<String>();
        samples.forEach(s -> all.addAll(s.getSpots()));
        return all;
    }

    private Action getExportToCsvWithIdentificationsAction() {
        this.exportToCsvWithIdentificationsAction = new AbstractAction("Export to CSV with identifications"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplesComparisonTable.this.exportToCsvWithIdentifications();
            }
        };
        this.exportToCsvWithIdentificationsAction.setEnabled(false);
        return this.exportToCsvWithIdentificationsAction;
    }

    protected void exportToCsvWithIdentifications() {
        ExportCsvDialog dialog = new ExportCsvDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            try {
                SpotsDataWriter.writeSamplesWithIdentifications(this.samples, (SpotMascotIdentifications)this.mascotIdentifications.get(), (CsvFormat)CsvUtils.csvFormat(dialog.getSelectedCsvFormat()), (File)dialog.getSelectedFile());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "There was an error writing to " + dialog.getSelectedFile(), "Input error", 0);
            }
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    public void setVisibleSpots(Set<String> visibleSpots) {
        this.spotPresenceTester.setVisibleSpots(visibleSpots);
        this.table.setRowFilter(new TestRowFilter(this.spotPresenceTester, 0));
    }

    public void setShowProteinIdentifications(boolean show) {
        this.showProteinIdentifications = show;
        this.updateUI();
    }

    public void setMascotIdentifications(SpotMascotIdentifications mascotIdentifications) {
        this.mascotIdentifications = Optional.ofNullable(mascotIdentifications);
        this.exportToCsvWithIdentificationsAction.setEnabled(true);
    }

    public void fireTableStructureChanged() {
        this.tableModel.fireTableStructureChanged();
    }

    public JHeatMapModel getHeatMapModel(SpotRenderer spotRenderer, boolean showSampleLabels) {
        return HeatMapModelBuilder.createHeatMapModelBuilder(this.table, spotRenderer).withMascotIdentifications(this.mascotIdentifications).withSampleLabels(showSampleLabels ? this.sampleLabels : Collections.emptyMap()).build();
    }

    public void addTableAction(Action a) {
        this.table.addAction(a);
    }

    public void setColumnsVisibility(List<Integer> columnIndices, boolean visible) {
        this.table.setColumnsVisibility(columnIndices, visible);
    }

    public void removeMascotIdentifications() {
        this.mascotIdentifications = Optional.empty();
    }

    public void setShowComponentPopupMenu(boolean show) {
        if (show) {
            this.table.setComponentPopupMenu(this.getSpotsTablePopupMenu());
        } else {
            this.table.setComponentPopupMenu(null);
        }
    }

    private JPopupMenu getSpotsTablePopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getRemoveSelectedRowsAction());
        menu.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SamplesComparisonTable.this.removeSpotsAction.setEnabled(SamplesComparisonTable.this.table.getSelectedRowCount() > 0);
            }
        });
        return menu;
    }

    private Action getRemoveSelectedRowsAction() {
        this.removeSpotsAction = new ExtendedAbstractAction("Remove selected spots", this::removeSelectedSpots);
        this.removeSpotsAction.setEnabled(false);
        return this.removeSpotsAction;
    }

    private void removeSelectedSpots() {
        if (this.table.getSelectedRowCount() > 0) {
            this.removeSelectedSpotsFromSamples();
            this.tableModel.fireTableDataChanged();
        }
    }

    private void removeSelectedSpotsFromSamples() {
        IntStream.of(this.table.getSelectedRows()).boxed().map(arg_0 -> this.table.convertRowIndexToModel(arg_0)).sorted(Collections.reverseOrder(Integer::compareTo)).forEach(i -> this.removeSpotFromSamples(this.tableModel.getValueAt((int)i, 0).toString()));
    }

    private void removeSpotFromSamples(String spot) {
        this.samples.forEach(s -> s.removeSpot(spot));
    }

    private class SamplesComparisonTableHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private TableCellRenderer defaultRenderer;

        public SamplesComparisonTableHeaderCellRenderer(TableCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int columnModel;
            Component c = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                c.setFont(c.getFont().deriveFont(1, 14.0f));
            }
            if ((columnModel = table.convertColumnIndexToModel(column)) > 0 && c instanceof JLabel) {
                ((JLabel)c).setToolTipText((String)SamplesComparisonTable.this.sampleLabels.get(SamplesComparisonTable.this.samples.get(columnModel - 1)));
            }
            return c;
        }
    }

    private class SamplesComparisonTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private SamplesComparisonTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int columnModel = table.convertColumnIndexToModel(column);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setFont(c.getFont().deriveFont(0, 14.0f));
            if (columnModel > 0) {
                if (c instanceof JLabel) {
                    String cellValue;
                    JLabel label = (JLabel)c;
                    String string = cellValue = Double.isNaN((Double)value) ? "" : String.format("%6.2e", value);
                    if (!Double.isNaN((Double)value)) {
                        label.setToolTipText(cellValue);
                    }
                    label.setText(cellValue);
                    Color background = (Color)SamplesComparisonTable.this.sampleColors.get(SamplesComparisonTable.this.samples.get(columnModel - 1));
                    if (background != null) {
                        c.setBackground(background);
                    }
                }
            } else {
                String spot = value.toString();
                JLabel spotLabel = (JLabel)c;
                spotLabel.setText(SpotUtils.spotValue(spot, SamplesComparisonTable.this.showProteinIdentifications, SamplesComparisonTable.this.mascotIdentifications));
                spotLabel.setToolTipText(SpotUtils.spotTooltip(spot, SamplesComparisonTable.this.mascotIdentifications));
                if (SamplesComparisonTable.this.mascotIdentifications.isPresent()) {
                    if (!((SpotMascotIdentifications)SamplesComparisonTable.this.mascotIdentifications.get()).get(spot).isEmpty()) {
                        if (!SamplesComparisonTable.this.showProteinIdentifications) {
                            spotLabel.setFont(c.getFont().deriveFont(1));
                        }
                    } else {
                        spotLabel.setForeground(Color.RED);
                    }
                }
            }
            return c;
        }
    }
}

