/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.heatmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.sing_group.gc4s.dialog.ColorsSelectionDialog;
import org.sing_group.gc4s.dialog.FontConfigurationDialog;
import org.sing_group.gc4s.dialog.ListSelectionDialog;
import org.sing_group.gc4s.input.DoubleRange;
import org.sing_group.gc4s.input.DoubleRangeInputDialog;
import org.sing_group.gc4s.ui.ColorListCellRenderer;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.ui.menu.HamburgerMenu;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.visualization.heatmap.JHeatMap;
import org.sing_group.gc4s.visualization.heatmap.JHeatMapDataOperationsDialog;
import org.sing_group.gc4s.visualization.heatmap.JHeatMapOperations;

public class JHeatMapPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String DESCRIPTION_RANGE_DIALOG = "This dialog allows you to select the minimum and maximum values used to create the color gradient.";
    protected static final String DESCRIPTION_FONT_DIALOG = "This dialog allows you to select the style and size of the font used in the heatmap.";
    protected static final String DESCRIPTION_VISIBLE_ROWS = "This dialog allows you to configure the visible rows. To do so, move them from one list to another using the controls.";
    protected static final String DESCRIPTION_VISIBLE_COLUMNS = "This dialog allows you to configure the visible columns. To do so, move them from one list to another using the controls.";
    private Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
    private JComboBox<Color> lowColorCB;
    private JComboBox<Color> highColorCB;
    private JHeatMap heatmap;
    private Optional<Font> heatmapFont = Optional.empty();

    public JHeatMapPanel(JHeatMap heatmap) {
        super(new BorderLayout());
        this.heatmap = heatmap;
        this.initComponent();
    }

    private void initComponent() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPanel toolbar = new JPanel();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        BoxLayout layout = new BoxLayout(toolbar, 0);
        toolbar.setLayout(layout);
        toolbar.add(this.getMenu());
        this.checkInitialColors();
        this.lowColorCB = new JComboBox<Color>(this.colors);
        this.lowColorCB.setRenderer((ListCellRenderer<Color>)new ColorListCellRenderer());
        this.fixComboSize(this.lowColorCB);
        this.lowColorCB.setSelectedItem(this.heatmap.getLowColor());
        this.lowColorCB.addItemListener(e -> this.heatmap.setLowColor((Color)this.lowColorCB.getSelectedItem()));
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(new JLabel("Low: "));
        toolbar.add(this.lowColorCB);
        this.highColorCB = new JComboBox<Color>(this.colors);
        this.fixComboSize(this.highColorCB);
        this.highColorCB.setRenderer((ListCellRenderer<Color>)new ColorListCellRenderer());
        this.highColorCB.setSelectedItem(this.heatmap.getHighColor());
        this.highColorCB.addItemListener(e -> this.heatmap.setHighColor((Color)this.highColorCB.getSelectedItem()));
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(new JLabel("High: "));
        toolbar.add(this.highColorCB);
        toolbar.add(Box.createHorizontalStrut(10));
        this.add((Component)toolbar, "North");
        this.add((Component)this.heatmap, "Center");
    }

    private void checkInitialColors() {
        LinkedList<Color> colorsList = new LinkedList<Color>(Arrays.asList(this.colors));
        if (!colorsList.contains(this.heatmap.getLowColor())) {
            colorsList.add(this.heatmap.getLowColor());
        }
        if (!colorsList.contains(this.heatmap.getHighColor())) {
            colorsList.add(this.heatmap.getHighColor());
        }
        this.colors = colorsList.toArray(new Color[colorsList.size()]);
    }

    private Component getMenu() {
        HamburgerMenu menu = new HamburgerMenu(HamburgerMenu.Size.SIZE16);
        menu.add((Action)new ExtendedAbstractAction("Set range", (Icon)Icons.ICON_RANGE_16, this::setHeatmapRange));
        menu.add((Action)new ExtendedAbstractAction("Transform data", (Icon)Icons.ICON_EDIT_16, this::transformDataMatrix));
        menu.add((Action)new ExtendedAbstractAction("Visible rows", (Icon)Icons.ICON_ROW_16, this::editVisibleRows));
        menu.add((Action)new ExtendedAbstractAction("Visible columns", (Icon)Icons.ICON_COLUMN_16, this::editVisibleColumns));
        menu.add((Action)new ExtendedAbstractAction("Configure font", (Icon)Icons.ICON_FONT_16, this::configureFont));
        menu.add((Action)new ExtendedAbstractAction("Edit colors", (Icon)Icons.ICON_PAINT_16, this::editColors));
        menu.add((Action)new ExtendedAbstractAction("Export heatmap as image", (Icon)Icons.ICON_IMAGE_16, this::exportAsImage));
        return menu;
    }

    protected void editVisibleRows() {
        List<String> visible = this.heatmap.getVisibleRowNames();
        List<String> notVisible = this.heatmap.getRowNames();
        notVisible.removeAll(visible);
        try {
            ListSelectionDialog<String> dialog = new ListSelectionDialog<String>(this.getDialogParent(), visible, notVisible, "Visible rows", "Not visible rows"){
                private static final long serialVersionUID = 1L;

                public String getDescription() {
                    return JHeatMapPanel.DESCRIPTION_VISIBLE_ROWS;
                }
            };
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.heatmap.setVisibleRowNames(dialog.getSelectedItems());
            }
        }
        catch (InvalidClassException e) {
            throw new RuntimeException(e);
        }
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    protected void editVisibleColumns() {
        List<String> visible = this.heatmap.getVisibleColumnNames();
        List<String> notVisible = this.heatmap.getColumnNames();
        notVisible.removeAll(visible);
        try {
            ListSelectionDialog<String> dialog = new ListSelectionDialog<String>(this.getDialogParent(), visible, notVisible, "Visible columns", "Not visible columns"){
                private static final long serialVersionUID = 1L;

                public String getDescription() {
                    return JHeatMapPanel.DESCRIPTION_VISIBLE_COLUMNS;
                }
            };
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.heatmap.setVisibleColumnNames(dialog.getSelectedItems());
            }
        }
        catch (InvalidClassException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setHeatmapRange() {
        DoubleRangeInputDialog dialog = new DoubleRangeInputDialog(this.getDialogParent(), new DoubleRange(this.heatmap.getLowValue(), this.heatmap.getHighValue())){
            private static final long serialVersionUID = 1L;

            protected String getDescription() {
                return JHeatMapPanel.DESCRIPTION_RANGE_DIALOG;
            }
        };
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.heatmap.setValuesRange(dialog.getSelectedRange());
        }
    }

    protected void exportAsImage() {
        JFileChooser fc = new JFileChooser();
        int result = fc.showSaveDialog(this);
        if (result == 0) {
            try {
                this.heatmap.toPngImage(fc.getSelectedFile());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void configureFont() {
        FontConfigurationDialog dialog = new FontConfigurationDialog(this.getDialogParent(), this.getHeatmapFont()){
            private static final long serialVersionUID = 1L;

            protected String getDescription() {
                return JHeatMapPanel.DESCRIPTION_FONT_DIALOG;
            }
        };
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.setHeatmapFont(dialog.getSelectedFont());
        }
    }

    private void setHeatmapFont(Font font) {
        this.heatmapFont = Optional.ofNullable(font);
        this.heatmap.setHeatmapFont(this.getHeatmapFont());
    }

    protected void editColors() {
        ColorsSelectionDialog dialog = new ColorsSelectionDialog(this.getDialogParent(), 2, Integer.MAX_VALUE, Arrays.asList(this.colors));
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.setColors(dialog.getSelectedColors());
        }
    }

    private void setColors(List<Color> selectedColors) {
        this.colors = selectedColors.toArray(new Color[selectedColors.size()]);
        Color previousLowColor = (Color)this.lowColorCB.getSelectedItem();
        Color previousHighColor = (Color)this.highColorCB.getSelectedItem();
        this.lowColorCB.setModel(new DefaultComboBoxModel<Color>(this.colors));
        this.highColorCB.setModel(new DefaultComboBoxModel<Color>(this.colors));
        boolean changeColors = false;
        if (selectedColors.contains(previousLowColor)) {
            this.lowColorCB.setSelectedItem(previousLowColor);
        } else {
            changeColors = true;
        }
        if (selectedColors.contains(previousHighColor)) {
            this.highColorCB.setSelectedItem(previousHighColor);
        } else {
            changeColors = true;
        }
        if (changeColors) {
            this.heatmap.setColors((Color)this.lowColorCB.getSelectedItem(), (Color)this.highColorCB.getSelectedItem());
        }
    }

    public Font getHeatmapFont() {
        return this.heatmapFont.orElse(this.getFont());
    }

    private void fixComboSize(JComboBox<Color> combobox) {
        Dimension d = new Dimension(120, 20);
        combobox.setSize(d);
        combobox.setMaximumSize(d);
        combobox.setPreferredSize(d);
    }

    private void transformDataMatrix() {
        JHeatMapDataOperationsDialog dialog = new JHeatMapDataOperationsDialog(this.getDialogParent());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.applyTransformations(dialog.getTransform(), dialog.getCentering());
        }
    }

    private void applyTransformations(JHeatMapOperations.Transform transform, JHeatMapOperations.Centering centering) {
        this.heatmap.setData(JHeatMapOperations.center(JHeatMapOperations.transform(this.heatmap.getData(), transform), centering, true));
    }
}

