/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.error;

import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.html.HTMLEditorKit;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 500;
    private final String message;
    private final Throwable error;
    private JPanel buttonsPanel;
    private JPanel infoPanel;

    public ErrorDialog(JFrame parent, Throwable error) {
        this(parent, error, error.getMessage());
    }

    public ErrorDialog(JFrame parent, Throwable error, String message) {
        super(parent);
        this.error = error;
        this.message = message;
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        layout.setVgap(5);
        this.getContentPane().setLayout(layout);
        this.add((Component)this.getButtonsPanel(), "South");
        this.setTitle("Error during operation");
        JTextPane errorArea = new JTextPane();
        errorArea.setEditorKit(new HTMLEditorKit());
        errorArea.setText("<font face='Dialog' size='7px'><b>There were an error during process:</b><br><font color='red'>" + this.message + "</font></font>");
        this.add((Component)new JScrollPane(errorArea), "North");
        errorArea.setEditable(false);
        errorArea.setMargin(new Insets(5, 5, 5, 5));
        errorArea.setPreferredSize(new Dimension(500, 50));
        this.pack();
        Utilities.centerOnOwner(this);
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new FlowLayout());
            this.buttonsPanel.setPreferredSize(new Dimension(500, 40));
            final JToggleButton moreInfoButton = new JToggleButton("Show Details...");
            moreInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (moreInfoButton.isSelected()) {
                        moreInfoButton.setText("Hide Details...");
                        ErrorDialog.this.showInfo();
                    } else {
                        moreInfoButton.setText("Show Details...");
                        ErrorDialog.this.hideInfo();
                    }
                }
            });
            this.buttonsPanel.add(moreInfoButton);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.setVisible(false);
                }
            });
            this.buttonsPanel.add(okButton);
        }
        return this.buttonsPanel;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            JTextArea area = new JTextArea();
            area.setText(this.getDetails());
            area.setCaretPosition(0);
            JScrollPane scroll = new JScrollPane(area);
            scroll.setPreferredSize(new Dimension(500, 200));
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.infoPanel.setLayout(layout);
            this.infoPanel.add((Component)new JLabel(), "East");
            this.infoPanel.add((Component)new JLabel(), "West");
            this.infoPanel.add((Component)scroll, "Center");
        }
        return this.infoPanel;
    }

    private String getDetails() {
        String message = "\n   Type of error: " + this.error.getClass().getSimpleName();
        String back = "";
        for (StackTraceElement el : this.error.getStackTrace()) {
            back = back + "\n      " + el.toString();
        }
        message = message + "\n   Back trace: " + back;
        return message;
    }

    private void showInfo() {
        this.add((Component)this.getInfoPanel(), "Center");
        this.setLocation(this.getLocation());
        this.pack();
    }

    private void hideInfo() {
        this.remove(this.getInfoPanel());
        this.setLocation(this.getLocation());
        this.pack();
    }
}

