/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SimpleIncomingEndPoint
extends IncomingEndPoint {
    private final Method method;
    private final Object target;
    private final BlockingQueue<Callable<Object>> queue = new LinkedBlockingQueue<Callable<Object>>();
    private final Lock lock = new ReentrantLock();
    private final Condition notEmptyOrFinish = this.lock.newCondition();
    private boolean finished = false;

    public SimpleIncomingEndPoint(Method method, Object target) {
        if (method == null) {
            throw new IllegalArgumentException("method can't be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target can't be null");
        }
        if (!method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException("the method must be applied to the object");
        }
        this.method = method;
        this.target = target;
    }

    @Override
    public final void finish() {
        try {
            this.lock.lock();
            this.finished = true;
            this.notEmptyOrFinish.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    final int getWorkToDo(Collection<Callable<Object>> collection) {
        try {
            this.lock.lock();
            while (!this.finished && this.queue.peek() == null) {
                this.notEmptyOrFinish.awaitUninterruptibly();
            }
            int n = this.queue.drainTo(collection);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected final void invoke(Object ... args) {
        try {
            this.lock.lock();
            if (this.finished) {
                throw new IllegalStateException("The session is already closed");
            }
            assert (args.length < 2);
            if (this.method.getParameterTypes().length == 0) {
                args = new Object[]{};
            }
            final Object[] finalArgs = args;
            this.queue.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object result;
                    try {
                        result = SimpleIncomingEndPoint.this.method.invoke(SimpleIncomingEndPoint.this.target, finalArgs);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (SimpleIncomingEndPoint.this.method.getReturnType().equals(Void.TYPE)) {
                        return Void.TYPE;
                    }
                    return result;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Class<?>[] getArgumentTypes() {
        return this.method.getParameterTypes();
    }
}

