/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.core.operation.annotation.ResultTreatment;
import es.uvigo.ei.aibench.core.operation.execution.OneCallEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.SimpleIncomingEndPoint;
import es.uvigo.ei.pipespecification.InvalidAnnotationsException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;

public class EndpointsFactory<T> {
    private final Direction direction;
    private final ResultTreatment treatment;
    private final Method targetMethod;
    private final Class<T> klass;
    private final Class<?> resultKlass;
    private final Class<?> argsClass;
    private static final Map<Class<?>, Class<?>> WRAPPERS = new HashMap();

    private Class<?> toWrapper(Class<?> klass) {
        if (WRAPPERS.containsKey(klass)) {
            return WRAPPERS.get(klass);
        }
        return klass;
    }

    private EndpointsFactory(Class<T> klass, Class<?>[] args, String methodName, Direction direction, ResultTreatment resultTreatment, Class<?> resultClass) throws InvalidAnnotationsException, IllegalArgumentException {
        if (klass == null) {
            throw new IllegalArgumentException("klass can't be null");
        }
        if (args.length > 1) {
            throw new IllegalArgumentException("the method can have at most one argument");
        }
        if (methodName.length() == 0) {
            throw new IllegalArgumentException("methodName must not be the empty string");
        }
        if (direction == null) {
            throw new InvalidAnnotationsException("The visibility specified can't be null");
        }
        if (resultTreatment == null) {
            throw new InvalidAnnotationsException("The treatment can't be null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass can't be null");
        }
        this.klass = klass;
        try {
            this.targetMethod = klass.getMethod(methodName, args);
        }
        catch (Exception e) {
            throw new InvalidAnnotationsException("The method specified doesn't exist in the class");
        }
        assert (this.targetMethod != null);
        this.argsClass = this.targetMethod.getParameterTypes().length > 0 ? this.targetMethod.getParameterTypes()[0] : Void.TYPE;
        this.direction = direction;
        if (direction == Direction.OUTPUT && this.targetMethod.getParameterTypes().length > 0) {
            throw new InvalidAnnotationsException("An output method cannot have arguments");
        }
        this.treatment = resultTreatment;
        Class<?> targetMethodReturnType = this.toWrapper(this.targetMethod.getReturnType());
        if (this.treatment == ResultTreatment.DATASOURCE) {
            if (!EndpointsFactory.isDataSourceCompatible(targetMethodReturnType)) {
                throw new InvalidAnnotationsException("The return type " + targetMethodReturnType + " is incompatible with being a dataSource");
            }
            this.resultKlass = targetMethodReturnType.getComponentType() == null ? resultClass : targetMethodReturnType.getComponentType();
        } else {
            this.resultKlass = targetMethodReturnType;
        }
    }

    private static boolean isDataSourceCompatible(Class<?> resultKlass) {
        return Iterable.class.isAssignableFrom(resultKlass) || Iterator.class.isAssignableFrom(resultKlass) || resultKlass.isArray();
    }

    public static <T> EndpointsFactory<T> createEndpointsFactory(Class<T> klass, Port port, Class<?>[] args, String methodName) throws InvalidAnnotationsException, IllegalArgumentException {
        if (port == null) {
            throw new IllegalArgumentException("port can't be null");
        }
        return new EndpointsFactory<T>(klass, args, methodName, port.direction(), port.resultTreatment(), port.resultClass());
    }

    public static <T> EndpointsFactory<T> createEndPointsFactory(Class<T> klass, final Element portElement) {
        if (portElement.getLocalName().equals("port")) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        return portElement.getNamespaceURI();
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        return null;
                    }

                    public Iterator<?> getPrefixes(String namespaceURI) {
                        return null;
                    }
                });
                String methodName = xPath.evaluate("p:method_name", portElement);
                Class<?> resultClass = Class.forName(xPath.evaluate("@result_class", portElement));
                ResultTreatment resultTreatment = ResultTreatment.valueOf(portElement.getAttribute("result_treatment").toUpperCase());
                Direction direction = Direction.valueOf(portElement.getAttribute("direction").toUpperCase());
                Class<?>[] args = EndpointsFactory.loadClasses(xPath.evaluate("p:args", portElement).split("\\s+"));
                return new EndpointsFactory<T>(klass, args, methodName, direction, resultTreatment, resultClass);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("it's necessary a port element");
    }

    private static Class<?>[] loadClasses(String[] strings) throws ClassNotFoundException {
        Class[] classes = new Class[strings.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = Class.forName(strings[i]);
        }
        return classes;
    }

    SimpleIncomingEndPoint instantiate(T target) {
        if (!this.klass.isInstance(target)) {
            throw new IllegalArgumentException("The target object is not of the target class");
        }
        if (this.direction == Direction.OUTPUT) {
            return new OneCallEndPoint(this.targetMethod, target);
        }
        return new SimpleIncomingEndPoint(this.targetMethod, target);
    }

    public void addArguments(List<Class<?>> incomeArguments, List<Class<?>> outcomeArguments) {
        if (this.direction != Direction.OUTPUT) {
            incomeArguments.add(this.argsClass);
        }
        if (this.direction != Direction.INPUT) {
            outcomeArguments.add(this.resultKlass);
        }
    }

    protected final Direction getDirection() {
        return this.direction;
    }

    protected final ResultTreatment getTreatment() {
        return this.treatment;
    }

    static {
        WRAPPERS.put(Byte.TYPE, Byte.class);
        WRAPPERS.put(Short.TYPE, Short.class);
        WRAPPERS.put(Character.TYPE, Character.class);
        WRAPPERS.put(Integer.TYPE, Integer.class);
        WRAPPERS.put(Long.TYPE, Long.class);
        WRAPPERS.put(Float.TYPE, Float.class);
        WRAPPERS.put(Double.TYPE, Double.class);
        WRAPPERS.put(Boolean.TYPE, Boolean.class);
    }
}

