/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.jsparklines.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import no.uib.jsparklines.data.XYDataPoint;

public class TableUtils {
    public static Double getMaxColumnValue(JTable table, int col) {
        return TableUtils.getColumnDoubleValues(table, col).stream().mapToDouble(d -> d).max().orElse(Double.NaN);
    }

    public static Double getMinColumnValue(JTable table, int col) {
        return TableUtils.getColumnDoubleValues(table, col).stream().mapToDouble(d -> d).min().orElse(Double.NaN);
    }

    private static List<Double> getColumnDoubleValues(JTable table, int col) {
        TableModel tableModel = table.getModel();
        TableUtils.requireNumberclass(tableModel.getColumnClass(col));
        List<Object> columnValues = TableUtils.getColumnValues(tableModel, col);
        return columnValues.stream().map(TableUtils::toDouble).collect(Collectors.toList());
    }

    private static void requireNumberclass(Class<?> columnClass) {
        if (!(Number.class.isAssignableFrom(columnClass) || XYDataPoint.class.isAssignableFrom(columnClass) || TableUtils.isPrimitiveNumeric(columnClass))) {
            throw new IllegalStateException("Numeric or XYDataPoint column required");
        }
    }

    private static boolean isPrimitiveNumeric(Class<?> columnClass) {
        return Double.TYPE.isAssignableFrom(columnClass) || Float.TYPE.isAssignableFrom(columnClass) || Integer.TYPE.isAssignableFrom(columnClass) || Long.TYPE.isAssignableFrom(columnClass);
    }

    private static Double toDouble(Object value) {
        if (Number.class.isAssignableFrom(value.getClass())) {
            return ((Number)value).doubleValue();
        }
        if (XYDataPoint.class.isAssignableFrom(value.getClass())) {
            return ((XYDataPoint)value).getX();
        }
        throw new IllegalArgumentException("Numeric or XYDataPoint column required");
    }

    private static List<Object> getColumnValues(TableModel tableModel, int col) {
        LinkedList<Object> values = new LinkedList<Object>();
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            values.add(tableModel.getValueAt(row, col));
        }
        return values;
    }
}

