/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.jsparklines.builders.barchartrenderer;

import java.awt.Color;
import javax.swing.JTable;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.sing_group.gc4s.jsparklines.JSparklinesBarChartTableCellRendererFactory;
import org.sing_group.gc4s.jsparklines.util.TableUtils;

public class MaximumMinimumXYDataSignificanceBarChartRendererBuilder {
    private int column;
    private JTable table;
    private Double maxValue;
    private Double minValue;
    private Color positiveValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_POSITIVES_COLOR;
    private Color negativeValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_NEGATIVES_COLOR;
    private PlotOrientation plotOrientation = JSparklinesBarChartTableCellRendererFactory.DEFAULT_ORIENTATION;
    private Double significanceLevel = 0.05;
    private Color nonSignificantValuesColor = JSparklinesBarChartTableCellRendererFactory.DEFAULT_NON_SIGNIFICANT_COLOR;

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withPlotOrientation(PlotOrientation plotOrientation) {
        this.plotOrientation = plotOrientation;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withMaxValue(Double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withMinValue(Double minValue) {
        this.minValue = minValue;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withNegativeValuesColor(Color negativeValuesColor) {
        this.negativeValuesColor = negativeValuesColor;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withNonSignificanteValuesColor(Color nonSignificantValuesColor) {
        this.nonSignificantValuesColor = nonSignificantValuesColor;
        return this;
    }

    public MaximumMinimumXYDataSignificanceBarChartRendererBuilder withSignificanceLevel(Double significanceLevel) {
        this.significanceLevel = significanceLevel;
        return this;
    }

    public JSparklinesBarChartTableCellRenderer build() {
        this.checkMaxMinValues();
        return JSparklinesBarChartTableCellRendererFactory.createMaxMinXYDataSignificanceBarChartRenderer(this.table, this.column, this.plotOrientation, this.minValue, this.maxValue, this.negativeValuesColor, this.positiveValuesColor, this.nonSignificantValuesColor, this.significanceLevel);
    }

    private void checkMaxMinValues() {
        if (this.maxValue == null) {
            this.maxValue = TableUtils.getMaxColumnValue(this.table, this.column);
        }
        if (this.minValue == null) {
            this.minValue = TableUtils.getMinColumnValue(this.table, this.column);
        }
    }
}

